/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.StringTokenizer;

public class TextShape
extends Shape {
    String text;
    Font textShapeFont;

    public TextShape(StringTokenizer stringTokenizer) {
        this.tag = stringTokenizer.nextToken();
        this.text = Base64Coder.decodeString(stringTokenizer.nextToken());
        this.X = Integer.parseInt(stringTokenizer.nextToken());
        this.Y = Integer.parseInt(stringTokenizer.nextToken());
        this.paintColor = stringTokenizer.hasMoreTokens() ? Shape.getColorParameter(stringTokenizer) : CanvasWidget.currentCanvas.currentPaint;
        if (stringTokenizer.hasMoreTokens()) {
            double d = Float.parseFloat(stringTokenizer.nextToken());
            d = Math.PI * 2 * d / 360.0;
            this.transform = AffineTransform.getRotateInstance(d, this.X, this.Y);
        }
        this.textShapeFont = CanvasWidget.currentCanvas.currentFont;
        CanvasWidget.currentCanvas.drawobjects.add(this);
    }

    public void drawShape(Graphics2D graphics2D) {
        graphics2D.setPaint(this.paintColor);
        graphics2D.setFont(this.textShapeFont);
        graphics2D.drawString(this.text, this.X, this.Y);
    }

    public boolean hasPoint(int n, int n2) {
        Component component = CanvasWidget.currentCanvas.component;
        FontMetrics fontMetrics = component.getFontMetrics(this.textShapeFont);
        int n3 = fontMetrics.getHeight();
        return new Rectangle(this.X, this.Y - n3, fontMetrics.stringWidth(this.text), n3).contains(n, n2);
    }
}

