// oCADis (C)opyright 2007 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "windialogs/windia_pagesetup.h"
#include "postoffice.h"
#include "messages.h"
#include "main.h"
#include "cadmath.h"

using namespace os;

WinDiaPageSetup :: WinDiaPageSetup( const Rect& cFrame, Document* current ) : Window( cFrame, "page_setup", "Page setup - oCADis" )
{
	// Create the mailbox
	AddMailbox( "Document" );

	// Create the table
	m_theTable = new TableView( Rect(), "", 1, 2, false );
	m_theTable->SetRowSpacings( 4 );
	AddChild( m_theTable );
	

	//////////////////////////////////////////////
	// Create the button table
	m_ButtonTable = new TableView( Rect(), "", 3, 1, true );
	m_ButtonTable->SetColumnSpacings( 5 );	
	AddChild( m_ButtonTable );

	m_OK = new Button( Rect(), "", "OK", new Message( MSG_OK ) );
	m_ButtonTable->Attach( m_OK, 1, 2, 0, 1, ( TABLE_EXPAND | TABLE_FILL ), 0 );	

	m_Cancel = new Button( Rect(), "", "Cancel", new Message( MSG_CANCEL ) );
	m_ButtonTable->Attach( m_Cancel, 2, 3, 0, 1, ( TABLE_EXPAND | TABLE_FILL ), 0 );	
	
	// Fix layout
	_Layout();

	// Close dialog with escape
	ShortcutKey s( VK_ESCAPE ); 
	AddShortcut( s, new Message( MSG_CANCEL ) );

	// Init pointers
	m_CurrentDocument = current;
}

WinDiaPageSetup :: ~WinDiaPageSetup()
{
	// Remove the mailbox
	RemoveMailbox( "Document" );

	delete m_theTable;
	delete m_ButtonTable;
	delete m_OK;
	delete m_Cancel;
}

void WinDiaPageSetup :: HandleMessage( os::Message* pcMessage )
{
	switch( pcMessage->GetCode() )	//Get the message code from the message
	{		
		case MSG_OK:
//			if( _Apply() )
				Hide();
			break;
		case MSG_CANCEL:
			Hide();
			break;

		// Broadcast messages
		case MSG_BROADCAST_NEW_DOCUMENT:
			if( pcMessage->FindPointer( "document", (void**) &m_CurrentDocument ) != EOK )
				m_CurrentDocument = NULL;
			break;
		default:
		{
			Window::HandleMessage( pcMessage );
			break;
		}
	}
}

bool WinDiaPageSetup ::OkToQuit( void )
{
	Hide();
	return false;
}

void WinDiaPageSetup :: FrameSized( const os::Point& delta )
{
	Window::FrameSized( delta );
	_Layout();
}
	
void WinDiaPageSetup :: Raise()
{
	if( IsVisible() )
		Hide();

	Show();
	MakeFocus();
}

//////////////////////////////////////////////////////////////////////
//
// P R I V A T E   M E T H O D S
//
//////////////////////////////////////////////////////////////////////

void WinDiaPageSetup :: _Layout()
{
	Rect cFrame = GetBounds();
	cFrame.Resize( 2, 2, -2, -2 );

	// Set button table
	Point tsize = m_ButtonTable->GetPreferredSize( false );
	Rect tframe( cFrame.right - tsize.x, cFrame.bottom - tsize.y, cFrame.right, cFrame.bottom );
	m_ButtonTable->SetFrame( tframe );

	// Set table
	Rect t1frame( cFrame.left, cFrame.top, cFrame.right, tframe.top - 2.0f );
	m_theTable->SetFrame( t1frame );
}

