// oCADis (C)opyright 2006 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "viewcoord.h"
#include <gui/font.h>

using namespace os;

ViewCoord :: ViewCoord( const Rect& cFrame, const String& cTitle, uint32 nResizeMask, uint32 nFlags ) : View( cFrame, cTitle, nResizeMask, nFlags )
{
	// Change size
	m_Font = GetFont();
	m_Font->SetSize( 6.0f );

	// Set this as default font
	SetFont( m_Font );

	// Calucate new font height
	font_height height;	
	GetFontHeight( &height );
	m_FontHeight = height.ascender + height.descender;
}

ViewCoord :: ~ViewCoord()
{
}

void ViewCoord :: Paint( const Rect& cUpdateRect )
{
	// Erase background noise
	FillRect( cUpdateRect, get_default_color( COL_NORMAL ) );

	// Set text colour
	SetFgColor( 0, 0, 0 );

	// Select font
	Rect c = GetBounds();
	float center = ( c.bottom - c.top ) / 2.0f + c.top;

	// Draw label
	DrawString( Point( c.left, center ), "X:" );
	DrawString( Point( c.left, center + m_FontHeight ), "Y:" );

	// Draw value
	float width = GetStringWidth( "X: " );

	DrawString( Point( c.left + width, center ), m_X );
	DrawString( Point( c.left + width, center + m_FontHeight ), m_Y );
}

void ViewCoord :: ClearCoord()
{
	m_X = m_Y = "";
	Invalidate();
	Flush();
}

Point ViewCoord :: GetPreferredSize( bool bLargest ) const
{
	return Point( GetStringWidth( "X: 00000.00000" ), m_FontHeight * 2.0f + 2.0f ) ;
}

void ViewCoord :: SetCoord( Point coord )
{
	m_X.Format( "%.4f", coord.x );
	m_Y.Format( "%.4f", coord.y );
	Invalidate();
	Flush();
}

