// oCADis (C)opyright 2007 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef __TOOL_TOOLSELECT_H_
#define __TOOL_TOOLSELECT_H_

#include "tool_state.h"
#include "tool.h"
#include "document.h"

class StateToolSelect : public ToolState
{
public:
	StateToolSelect( Tool* tool, ToolboxSideBar* parent );
	~StateToolSelect();

	void AddMainButton();
	void AddButton( Tool* tool );	

	os::String GetStatusText() { return os::String( "Select type of action" ); };

	virtual void SetFrame( const os::Rect& cRect, bool bNotifyServer = true );
	virtual void HandleMessage( os::Message* pcMessage );
	void AllAttached( void );

private:
	class Private;
	Private* m;
};

#endif
