// oCADis (C)opyright 2007 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include <vector>
#include "common.h"
#include "main.h"
#include "toolbox_button.h"
#include "toolbox_action.h"
#include "tableview.h"
#include "tool_selecttool.h"

using namespace os;
using namespace std;

///////////////////////////////////////////////////////////////////////////////
//
// P R I V A T E
//
///////////////////////////////////////////////////////////////////////////////

class StateToolSelect :: Private
{
public:
	Private(){};

	void _Layout( Rect cFrame )
	{
		m_Action->SetFrame( Rect( 0, 0, cFrame.Width(), cFrame.Height() ) );
	}

	enum StateToolSelectMessage { MSG_MAIN, MSG_SET_TOOL };

	ToolboxAction* m_Action;

	// Tools
	vector< Tool* > m_ListOfTools;
};

///////////////////////////////////////////////////////////////////////////////
//
// T H E   C L A S S
//
///////////////////////////////////////////////////////////////////////////////

StateToolSelect :: StateToolSelect( Tool* theTool, ToolboxSideBar* toolbox ) : ToolState( theTool, toolbox )
{	
	// Create the private class
	m = new Private();

	// Create the action
	m->m_Action = new ToolboxAction( Rect(), "tjo" );
	m->m_Action->ShowLabel( false );
	m->m_Action->ShowFrame( false );
	AddChild( m->m_Action );

	State::SetToolbox( this );
}

StateToolSelect :: ~StateToolSelect()
{
	delete m;
}

void StateToolSelect :: SetFrame( const Rect& cRect, bool bNotifyServer )
{
	Toolbox::SetFrame( cRect, bNotifyServer );
	m->_Layout( GetFrame() );
}

void StateToolSelect :: AllAttached( void )
{
	Toolbox::AllAttached();
	m->m_Action->SetTarget( this );
}

void StateToolSelect:: HandleMessage( Message* pcMessage )
{
	switch( pcMessage->GetCode() )
	{
	case Private::MSG_MAIN:
		SetMainToolbox();
		break;
	case Private::MSG_SET_TOOL:
		{
			Tool* tool;
			int8 state;

			if( pcMessage->FindPointer( "tool", (void**) &tool ) != EOK )
				break;

			if( pcMessage->FindInt8( "state", &state ) != EOK )
				break;

			tool->Init( state );
		}
		break;
	}
}

void StateToolSelect :: AddMainButton()
{
	m->m_Action->AddButton( "Main", (Image*) LoadImage( "cancel.png"  ), new Message( Private::MSG_MAIN ), "Returns to main toolbox" );
}

void StateToolSelect :: AddButton( Tool* tool )
{
	m->m_ListOfTools.push_back( tool );

	Message* msg = new Message( Private::MSG_SET_TOOL );
	msg->AddInt8( "state", tool->InitState() );
	msg->AddPointer( "tool", (void*) tool );
	
	m->m_Action->AddButton( tool->Name(), (Image*) LoadImage( tool->Image() ), msg, tool->Description() );
}

