// oCADis (C)opyright 2006 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "tool_modify_state_0.h"
#include "common.h"
#include "main.h"
#include "tool_move/tool_move.h"
#include "tool_erase/tool_erase.h"
#include "tool_rotate/tool_rotate.h"
#include "tool_align/tool_align.h"

using namespace os;

///////////////////////////////////////////////////////////////////////////////
//
// T H E   C L A S S
//
///////////////////////////////////////////////////////////////////////////////
ModifyState0 :: ModifyState0( Tool* theTool, ToolboxSideBar* toolbox ) : StateToolSelect( theTool, toolbox )
{	
/*	// Create the private class
	m = new Private();

	// Create the table
	m->m_Table = new TableView( Rect(), "", 1, 5, true );
	m->m_Table->SetRowSpacings( 4 );
	AddChild( m->m_Table );

	// Create buttons and attach them to table	
	m->m_Main = new ToolboxButton( Rect(), String( "Main" ), (Image*) LoadImage( "cancel.png" ), new Message( Private::MSG_MAIN ) , String( "Returns to main toolbox" ) );
	m->m_Main->SetTarget( this );
	m->m_Table->Attach( m->m_Main, 0, 1, 0, 1, ( TABLE_EXPAND | TABLE_FILL ), 0 );

	// Create move
	m->m_ToolMove = new ToolMove( toolbox );
	Message* msg = new Message( Private::MSG_SET_TOOL );
	msg->AddInt8( "state", 0 );
	msg->AddPointer( "tool", (void*) m->m_ToolMove );
	m->m_Move = new ToolboxButton( Rect(), String( "Move" ), (Image*) LoadImage( "line.png" ), msg, String( "Move objects " ) );
	m->m_Move->SetTarget( this );
	m->m_Table->Attach( m->m_Move, 0, 1, 1, 2, ( TABLE_EXPAND | TABLE_FILL ), 0 );

	m->m_ToolErase = new ToolErase( toolbox );
	Message* msg2 = new Message( Private::MSG_SET_TOOL );
	msg2->AddInt8( "state", 0 );
	msg2->AddPointer( "tool", (void*) m->m_ToolErase );
	m->m_Erase = new ToolboxButton( Rect(), String( "Erase" ), (Image*) LoadImage( "line.png" ), msg2, String( "Erase objects " ) );
	m->m_Erase->SetTarget( this );
	m->m_Table->Attach( m->m_Erase, 0, 1, 2, 3, ( TABLE_EXPAND | TABLE_FILL ), 0 );

	m->m_ToolRotate = new ToolRotate( toolbox );
	Message* msg4 = new Message( Private::MSG_SET_TOOL );
	msg4->AddInt8( "state", 0 );
	msg4->AddPointer( "tool", (void*) m->m_ToolRotate );
	m->m_Rotate = new ToolboxButton( Rect(), String( "Rotate" ), (Image*) LoadImage( "line.png" ), msg4, String( "Rotate objects " ) );
	m->m_Rotate->SetTarget( this );
	m->m_Table->Attach( m->m_Rotate, 0, 1, 3, 4, ( TABLE_EXPAND | TABLE_FILL ), 0 );

	m->m_ToolAlign = new ToolAlign( toolbox );
	Message* msg5 = new Message( Private::MSG_SET_TOOL );
	msg5->AddInt8( "state", 0 );
	msg5->AddPointer( "tool", (void*) m->m_ToolAlign );
	m->m_Align = new ToolboxButton( Rect(), String( "Align" ), (Image*) LoadImage( "line.png" ), msg5, String( "Align objects " ) );
	m->m_Align->SetTarget( this );
	m->m_Table->Attach( m->m_Align, 0, 1, 4, 5, ( TABLE_EXPAND | TABLE_FILL ), 0 );

	State::SetToolbox( this );*/

	AddMainButton();
	AddButton( new ToolMove( toolbox ) );
	AddButton( new ToolErase( toolbox ) );
	AddButton( new ToolRotate( toolbox ) );
	AddButton( new ToolAlign( toolbox ) );
}

ModifyState0 :: ~ModifyState0()
{
}

