// oCADis (C)opyright 2006 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "tool_circle_state_3.h"
#include "common.h"

using namespace os;

///////////////////////////////////////////////////////////////////////////////
//
// P R I V A T E
//
///////////////////////////////////////////////////////////////////////////////

class CircleState3 :: _Private
{
public:
	_Private(){};

	void _Layout( Rect cFrame )
	{
		m_Table->SetFrame( Rect( 0, 0, cFrame.Width(), cFrame.Height() ) );
	}

	enum CircleState3Message { MSG_POINT, MSG_CANCEL, MSG_CENTER, MSG_3P };

	ToolboxPoint* m_FirstPoint;
	ToolboxAction* m_Action;

	os::TableView* m_Table;
};

///////////////////////////////////////////////////////////////////////////////
//
// T H E   C L A S S
//
///////////////////////////////////////////////////////////////////////////////
CircleState3 :: CircleState3( ToolCircle* theTool, ToolboxSideBar* toolbox ) : ToolState( theTool, toolbox )
{
	// Create the private class
	m = new _Private();

	// Create the table
	m->m_Table = new TableView( Rect(), "", 1, 2, false );
	m->m_Table->SetRowSpacings( 4 );
	AddChild( m->m_Table );

	// Create buttons and attach them to table
	m->m_FirstPoint = new ToolboxPoint( Rect(), "First point", "X: ", "Y: ", new Message( _Private::MSG_POINT ) );
	m->m_Table->Attach( m->m_FirstPoint, 0, 1, 0, 1, ( TABLE_EXPAND | TABLE_FILL ), 0 );

	m->m_Action = new ToolboxAction( Rect(), "" );
	m->m_Table->Attach( m->m_Action, 0, 1, 1, 2, ( TABLE_EXPAND | TABLE_FILL ), ( TABLE_EXPAND | TABLE_FILL ) );

	// Add action items
	m->m_Action->AddButton( "Cancel", (Image*) LoadImage( "cancel.png" ), new Message( _Private::MSG_CANCEL ) , "Cancel the tool and return to main toolbox " );
	m->m_Action->AddButton( "Center", (Image*) LoadImage( "circle.png" ), new Message( _Private::MSG_CENTER ) , "Specify the center of the circle " );
	m->m_Action->AddButton( "3P", (Image*) LoadImage( "circle.png" ), new Message( _Private::MSG_3P ) , "Specify 3 points on the circle  " );

	State::SetToolbox( this );
}

CircleState3 :: ~CircleState3()
{	
	delete m;
}

void CircleState3 :: GotFocus( Canvas* canvas, Document* doc, Point coord )
{
	coord = doc->MakeSnap( coord );
	m->m_FirstPoint->SetValue( coord );
}

void CircleState3 :: LostFocus( Canvas* canvas, Document* doc, Point coord )
{
	m->m_FirstPoint->ClearValue();
}

void CircleState3 :: MouseMove( Canvas* canvas, Document* doc, Point coord )
{
	coord = doc->MakeSnap( coord );
	m->m_FirstPoint->SetValue( coord );
}

String CircleState3 :: GetStatusText()
{
	return String( "Select first point of the circle" );
}

void CircleState3 :: PointSelected( Canvas* canvas, Document* doc, Point coord )
{
	coord = doc->MakeSnap( coord );
	GetTool()->SetProperty( "first_point", coord );
	GetTool()->SetState( 4 );
}

void CircleState3 :: SetFrame( const Rect& cRect, bool bNotifyServer )
{
	Toolbox::SetFrame( cRect, bNotifyServer );
	m->_Layout( cRect );
}

void CircleState3 :: AllAttached( void )
{
	Toolbox::AllAttached();

	m->m_FirstPoint->SetTarget( this );
	m->m_Action->SetTarget( this );
}

void CircleState3 :: HandleMessage( Canvas* canvas, Document* doc, Message* pcMessage )
{
	switch( pcMessage->GetCode() )
	{
		case _Private::MSG_CENTER:
			GetTool()->SetState( 0 );
			break;
		case _Private::MSG_3P:
			GetTool()->SetState( 5 );
			break;
		case _Private::MSG_CANCEL:
			SetMainToolbox();
			break;
		case _Private::MSG_POINT:
			{
				Point p;

				if( pcMessage->FindPoint( "value", &p ) == EOK )
					PointSelected( canvas, doc, p );
		
				break;
			}
	}
}

