// oCADis (C)opyright 2006 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "tool_arc_state_4.h"
#include "common.h"
#include "windialogs/windia_alert.h"

using namespace os;

///////////////////////////////////////////////////////////////////////////////
//
// P R I V A T E
//
///////////////////////////////////////////////////////////////////////////////

class ArcState4 :: _Private
{
public:
	_Private(){};

	void _Layout( Rect cFrame )
	{
		m_Table->SetFrame( Rect( 0, 0, cFrame.Width(), cFrame.Height() ) );
	}

	enum ArcState4Message { MSG_POINT, MSG_CANCEL };
	
	ToolboxPoint* m_StartPoint;
	ToolboxAction* m_Action;

	TableView* m_Table;
};

///////////////////////////////////////////////////////////////////////////////
//
// T H E   C L A S S
//
///////////////////////////////////////////////////////////////////////////////
ArcState4 :: ArcState4( ToolArc* theTool, ToolboxSideBar* toolbox ) : ToolState( theTool, toolbox )
{
	// Create the private class
	m = new _Private();

	// Create the table
	m->m_Table = new TableView( Rect(), "", 1, 2, false );
	m->m_Table->SetRowSpacings( 4 );
	AddChild( m->m_Table );

	// Create buttons and attach them to table
	m->m_StartPoint = new ToolboxPoint( Rect(), "Start point", "X: ", "Y: ", new Message( _Private::MSG_POINT ) );
	m->m_Table->Attach( m->m_StartPoint, 0, 1, 0, 1, ( TABLE_EXPAND | TABLE_FILL ), 0 );

	m->m_Action = new ToolboxAction( Rect(), "" );
	m->m_Table->Attach( m->m_Action, 0, 1, 1, 2, ( TABLE_EXPAND | TABLE_FILL ), ( TABLE_EXPAND | TABLE_FILL ) );

	// Add action items
	m->m_Action->AddButton( "Cancel", (Image*) LoadImage( "cancel.png" ), new Message( _Private::MSG_CANCEL ) , "Cancel the tool and return to main toolbox " );

	State::SetToolbox( this );
}

ArcState4 :: ~ArcState4()
{	
	delete m;
}

void ArcState4 :: Init( Canvas* canvas, Document* doc )
{
	canvas->PrepareForXORMode();
}

void ArcState4 :: GotFocus( Canvas* canvas, Document* doc, Point coord )
{
	coord = doc->MakeSnap( coord );
	m->m_StartPoint->SetValue( coord );
}

void ArcState4 :: LostFocus( Canvas* canvas, Document* doc, Point coord )
{
	canvas->Undraw();
	m->m_StartPoint->ClearValue();
}

void ArcState4 :: MouseMove( Canvas* canvas, Document* doc, Point coord )
{
	coord = doc->MakeSnap( GetTool()->GetPropertyAsPoint( "center_point" ), coord );
	m->m_StartPoint->SetValue( coord );
	canvas->SetDefaultStyle();
	canvas->DrawLine( GetTool()->GetPropertyAsPoint( "center_point" ), coord, true );
}

String ArcState4 :: GetStatusText()
{
	return String( "Select start point of the arc" );
}

void ArcState4 :: PointSelected( Canvas* canvas, Document* doc, Point coord )
{
	coord = doc->MakeSnap( coord );
	GetTool()->SetProperty( "start_point", coord );
	canvas->Undraw();
	GetTool()->SetState( 5 );
}

void ArcState4 :: SetFrame( const Rect& cRect, bool bNotifyServer )
{
	Toolbox::SetFrame( cRect, bNotifyServer );
	m->_Layout( cRect );
}

void ArcState4 :: AllAttached( void )
{
	Toolbox::AllAttached();

	m->m_StartPoint->SetTarget( this );
	m->m_Action->SetTarget( this );
}

void ArcState4 :: HandleMessage( Canvas* canvas, Document* doc, Message* pcMessage )
{
	switch( pcMessage->GetCode() )
	{
		case _Private::MSG_CANCEL:
			SetMainToolbox();
			break;
		case _Private::MSG_POINT:
			{
				Point p;

				if( pcMessage->FindPoint( "value", &p ) == EOK )
					PointSelected( canvas, doc, p );
		
				break;
			}
	}
}

