// oCADis (C)opyright 2006 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include <cassert>

#include "style.h"
#include "layer.h"
#include "main.h"
#include "cadmath.h"

using namespace os;
using namespace std;

Style :: Style() 
{ 
	m_LineWidthType = BY_LAYER; 
	m_ColourType = BY_LAYER; 
	m_PatternType = BY_LAYER;
	m_Layer = NULL; 
}

double Style :: GetLineWidth()
{ 
	if( m_LineWidthType == BY_USER)  
		return m_LineWidth;  
	else
	{
		assert( m_Layer != NULL );
		return m_Layer->GetStyle().GetLineWidth();
	}
}

void Style :: GetColour( double& r, double& g, double& b )
{ 
	if( m_ColourType == BY_USER)  
	{
		r = m_R;
		b = m_B;
		g = m_G;
	}
	else
	{
		assert( m_Layer != NULL );

		m_Layer->GetStyle().GetColour( r, g, b );
	}
}

Pattern* Style :: GetPattern()
{ 
	if( m_PatternType == BY_USER)  
	{
		if( m_Pattern == NULL )
			m_Pattern = GET_DOCUMENT()->GetPattern( m_PatternName );

		if( m_Pattern == NULL )
			printf( "Style::GetPattern() Userdefined pattern \"%s\" not found", m_PatternName.c_str() );

		return m_Pattern;	
	}
	else
	{
		assert( m_Layer != NULL );

		return m_Layer->GetStyle().GetPattern();
	}
}

void Style :: SetStyle( int index, vector< String >& split )
{
	// Get the colour
	if( split[ index ] == "B" )
	{
		m_ColourType = BY_BLOCK;
		index++;
	}
	else if( split[ index ] == "L" )
	{
		m_ColourType = BY_LAYER;
		index++;
	}
	else if( split[ index ] == "U" )
	{
		m_ColourType = BY_USER;
		m_R = CadMath::Strtod( split[ index + 1 ] );
		m_G = CadMath::Strtod( split[ index + 2 ] );
		m_B = CadMath::Strtod( split[ index + 3 ] );
		index += 4;
	}

	// Get pattern type
	if( split[ index ] == "B" )
	{
		m_PatternType = BY_BLOCK;
		index++;
	}
	else if( split[ index ] == "L" )
	{
		m_PatternType = BY_LAYER;
		index++;
	}
	else if( split[ index ] == "U" )
	{
		m_PatternType = BY_USER;
		m_PatternName =	split[ index + 1 ];
		m_Pattern = NULL;
		index += 2;
	}

	// Get linewidth type
	if( split[ index ] == "B" )
	{
		m_LineWidthType = BY_BLOCK;
	}
	else if( split[ index ] == "L" )
	{
		m_LineWidthType = BY_LAYER;
	}
	else if( split[ index ] == "U" )
	{
		m_LineWidthType = BY_USER;
		m_LineWidth = CadMath::Strtod( split[ index + 1 ] );
	}
}

String Style :: SaveAttributes()
{
	String ret = ", ";

	// Save the colour
	switch( m_ColourType )
	{
		case BY_BLOCK:
			ret += "B, ";
			break;
		case BY_LAYER:
			ret += "L, ";
			break;
		case BY_USER:
		{
			ret += "U, ";
			String r;
			r.Format( "%f", m_R );
			String g;
			g.Format( "%f", m_G );
			String b;
			b.Format( "%f", m_B );

			ret += r + ", " + g + ", " + b + ", ";
			break;
		}
	}

	// Save pattern type
	switch( m_PatternType )
	{
		case BY_BLOCK:
			ret += "B, ";
			break;
		case BY_LAYER:
			ret += "L, ";
			break;
		case BY_USER:
		{
			ret += "U, \"";
			ret += m_Pattern->GetName();
			ret += "\", ";
			break;
		}
	}

	// Save linewidth type
	switch( m_LineWidthType )
	{
		case BY_BLOCK:
			ret += "B";
			break;
		case BY_LAYER:
			ret += "L";
			break;
		case BY_USER:
		{
			ret += "U, ";
			String r;
			r.Format( "%f", m_LineWidth );
			ret += r;
			break;
		}
	}
	
	ret +="\n";

	return ret;
}
