// oCADis (C)opyright 2006 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "prompt.h"

using namespace os;

Prompt :: Prompt( Rect cFrame, const String& cName, Message* pcMessage,
				  uint32 nResizeMask, uint32 nFlags ) : 
				  View( cFrame, cName, nResizeMask, nFlags )
{
	// Message whne user press return
	m_theMessage = pcMessage;

	// Create widgets
	m_Prompt = new StringView( Rect(), "prompt", "Command: " );
	AddChild( m_Prompt );

	m_Entry = new SLTextView( Rect(), "entry", m_theMessage );	
	AddChild( m_Entry );

	m_Output = new TextView( Rect(), "output", "" );	
	m_Output->SetMultiLine( true );
	m_Output->SetReadOnly();
	AddChild( m_Output );

	Layout();
}

Prompt::~Prompt()
{
	delete m_Entry;
	delete m_Prompt;
	delete m_Output;
}

void Prompt :: SetPrompt( String prompt )
{
	m_Prompt->SetString( prompt );
	Layout();
}

void Prompt :: Print( String p )
{
	String tmp = m_Output->GetValue().AsString();
	
	if( tmp == "" )
		tmp = p;
	else
		tmp = tmp + "\n" + p;

	m_Output->Set( tmp.c_str() );
}

void Prompt :: FrameSized( const Point& cDelta )
{
	Layout();

	View::FrameSized( cDelta );
}

void Prompt :: SetFrame( const Rect& cRect, bool bNotifyServer )
{
	View::SetFrame( cRect, bNotifyServer );

	Layout();
}

Point Prompt :: GetPreferredSize( bool bLargest )
{
	return Point( m_Prompt->GetPreferredSize( bLargest ).x + m_Entry->GetPreferredSize( bLargest ).x + 9.0f,
				  m_Entry->GetPreferredSize( bLargest ).y + 5.0f  );
}


void Prompt :: Layout()
{
	Rect cRect = GetBounds();

	Rect cOutput = Rect( cRect.left + 3.0f, cRect.top + 3.0f, cRect.right - 3.0f, cRect.bottom - ( m_Entry->GetPreferredSize( false ).y + 5.0f ) );
	m_Output->SetFrame( cOutput );

	cRect.top = cOutput.bottom;

	Point cLabelFrame = m_Prompt->GetPreferredSize( false );
	Rect cLabel = Rect( cRect.left + 3.0f, cRect.top + 3.0f + 4.0f, cRect.left + cLabelFrame.x + 3.0f, cRect.top + cLabelFrame.y + 3.0f + 4.0f );
	m_Prompt->SetFrame( cLabel );

	Point cEntryFrame = m_Entry->GetPreferredSize( false );
	Rect cEntry = Rect( cLabel.right + 3.0f, cRect.top +3.0f + 2.0f, cRect.right - 3.0f, cRect.top + 3.0f + cEntryFrame.y + 2.0f );
	m_Entry->SetFrame( cEntry );
}
