// oCADis (C)opyright 2006 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef __PATTERN_H_
#define __PATTERN_H_

#include <vector>
#include <util/string.h>

class Pattern
{
public:
	Pattern( os::String name ) { m_Name = name; m_Scale = 1.0f; m_Offset = 0.0f; m_AllowZooming = true; };
	Pattern( os::String name, int count, ... );
	~Pattern();

	os::String GetName() { return m_Name; };

	bool IsSolid() { return m_Pattern.empty(); };

	void AllowZooming( bool ret = true ) { m_AllowZooming = ret; };
	bool IsZoomingAllowed() { return m_AllowZooming; };

	void SetScale( double scale ) { m_Scale = scale; };
	double GetScale() { return m_Scale; };

	void SetOffset( double offset ) { m_Offset = offset; };
	double GetOffset() { return m_Offset; };
	
	void ClearPattern() { m_Pattern.clear(); };
	void AddPattern( double p ) { m_Pattern.push_back( p ); };
	
	int GetDashesCount() { return m_Pattern.size(); };
	double GetDash( int i ) { return m_Pattern[ i ] * m_Scale; };

	os::String Save();
private:
	os::String m_Name;

	bool m_AllowZooming;
	
	double m_Scale;
	double m_Offset;
	
	std::vector< double > m_Pattern;
};

#endif

