// oCADis (C)opyright 2007 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef __LAYER_H_
#define __LAYER_H_

#include <vector>

#include "object.h"
#include "style.h"
#include "pattern.h"

class Canvas;
class Object;

class Layer
{
public:
	Layer( os::String name, Pattern* pattern );
	Layer( os::String name, double r, double g, double b, double linewidth, Pattern* pattern, bool visible, bool editable );
	Layer( os::String name, double r, double g, double b, double linewidth, os::String pattern, bool visible, bool editable );
	Layer( os::String name, os::Color32_s colour, double linewidth, Pattern* pattern, bool visible, bool editable );

	~Layer();

	void AddObject( Object* obj );
	bool RemoveObject( Object* obj );
	bool ReplaceObject( Object* old_obj, Object* new_obj );

	void Redraw( Canvas* canvas );
	void Erase( Canvas* canvas );

	void SetVisible( bool vis ) { m_Visible = vis; };
	bool IsVisible() { return m_Visible; };

	void SetEditable( bool edit ) { m_Editable = edit; };
	bool IsEditable() { return m_Editable; };

	int GetObjectCount()  { return m_ListOfObjects.size(); };
	Object* GetObject( int no ) { return m_ListOfObjects.at( no ); };

	Style& GetStyle() { return m_Style; };
	void SetStyle( Style& style ) { m_Style = style; };

	os::String GetName() { return m_Name; };
	void SetName( os::String name ) { m_Name = name; };

	os::String Save();

	bool ObjectExists( Object* object );
private:
	std::vector< Object* > m_ListOfObjects;

	Style m_Style;

	bool m_Visible;
	bool m_Editable;
	
	os::String m_Name;
};
#endif
