// oCADis (C)opyright 2007 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef __FILTER_PS_H__
#define __FILTER_PS_H__

#include <fstream>
#include <vector>

#include "filters/filter_base.h"

#include "object_line.h"
#include "object_circle.h"
#include "object_arc.h"

class FilterPS : public FilterBase
{
public:
	FilterPS() {};
	 ~FilterPS() {};

	void Save( os::String& path, Document& doc );
	os::String GetExtension();
	os::String GetMenuString();
private:
	void _GenerateHeader( std::ofstream& fout, Document& doc );
	void _GenerateObjects( std::ofstream& fout, Document& doc );
	void _GenerateEOF( std::ofstream& fout, Document& doc );
	void _SetLayer( std::ofstream& fout, Layer* layer );
	bool _SetObject( std::ofstream& fout, Object* obj );
	double _GetIntensity( double r, double g, double b );

	os::Point _WorldToPS( os::Point wld );
	double _WorldToPS( double value );

	void _ObjectLine( std::ofstream& fout, Object* line );
	void _ObjectArc( std::ofstream& fout, Object* arc );
	void _ObjectCircle( std::ofstream& fout, Object* circle );

	os::Point m_PlotCenter;
	os::Point m_PlotPan;
	double m_ZoomFactor;
	bool m_PageLandscape;
	double m_PageHeight;
	double m_PageWidth;
};

#endif

