// oCADis (C)opyright 2006 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


#ifndef __VIEWCOORD_H_
#define __VIEWCOORD_H_

#include <gui/view.h>
#include <gui/rect.h>
#include <gui/point.h>

class ViewCoord : public os::View
{
public:
	ViewCoord( const os::Rect& cFrame, const os::String& cTitle, uint32 nResizeMask = os::CF_FOLLOW_LEFT | os::CF_FOLLOW_TOP,
			   uint32 nFlags = os::WID_WILL_DRAW | os::WID_CLEAR_BACKGROUND | os::WID_FULL_UPDATE_ON_RESIZE );
	~ViewCoord();

	virtual void Paint( const os::Rect& cUpdateRect );
	virtual os::Point GetPreferredSize( bool bLargest ) const;

	virtual void SetCoord( os::Point coord );
	virtual void ClearCoord();

private:
	os::Font* m_Font;

	os::String m_X;
	os::String m_Y;

	// Some precaculate values
	float m_FontHeight;

};

#endif
