// oCADis (C)opyright 2006 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include <cmath>

#include "transform.h"

using namespace os;

Transform :: Transform()
{
	m_sx = 1.0f; 
	m_shy = 0.0f; 
	m_shx = 0.0f;
	m_sy = 1.0f;
	m_tx = 0.0;
	m_ty = 0.0;

	m_Translation = Point( 0.0f, 0.0f );
}

Transform :: Transform( double v0, double v1, double v2, double v3, double v4, double v5 )
{
	m_sx = v0;
	m_shy = v1;
	m_shx = v2;
	m_sy = v3;
	m_tx = v4;
	m_ty = v5;
}

Transform :: ~Transform()
{
}

void Transform :: Translation( Point delta )
{
	Transform m( 1.0f, 0.0f, 0.0f, 1.0f, delta.x, delta.y );

	_Multiply( m );
}

void Transform :: Rotation( double angle )
{
	Transform m( cos( angle ), sin( angle), -sin( angle), cos( angle ), 0.0f, 0.0f );

	_Multiply( m );
}

void Transform :: Scaling( double x, double y )
{
	Transform m( x, 0.0f, 0.0f, y, 0.0f, 0.0f );

	_Multiply( m );
}

void Transform :: Scaling( double s )
{
	Transform m( s, 0.0f, 0.0f, s, 0.0f, 0.0f );

	_Multiply( m );
}

void Transform :: FlipX()
{
	m_sx  = -m_sx;
	m_shy = -m_shy;
	m_tx  = -m_tx;
}

void Transform :: FlipY()
{
	m_shx = -m_shx;
	m_sy  = -m_sy;
	m_ty  = -m_ty;
}

Point Transform :: Calculate( Point value )
{
	Point r( value.x * m_sx  + value.y * m_shx + m_tx, value.x * m_shy + value.y * m_sy  + m_ty );

	return r;
}

void Transform :: _Multiply( Transform& transform )
{
	double t0 = m_sx * transform.m_sx + m_shy * transform.m_shx;
	double t2 = m_shx * transform.m_sx + m_sy * transform.m_shx;
	double t4 = m_tx  * transform.m_sx + m_ty * transform.m_shx + transform.m_tx;
	m_shy = m_sx  * transform.m_shy + m_shy * transform.m_sy;
	m_sy  = m_shx * transform.m_shy + m_sy  * transform.m_sy;
	m_ty  = m_tx  * transform.m_shy + m_ty  * transform.m_sy + transform.m_ty;
	m_sx  = t0;
	m_shx = t2;
	m_tx  = t4;
}

