// oCADis (C)opyright 2006 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef __TOOLBOX_POINT_H__
#define __TOOLBOX_POINT_H__

#include <gui/control.h>
#include <gui/checkbox.h>
#include <gui/stringview.h>
#include <util/string.h>
#include <util/message.h>

#include "tableview.h"
#include "sltextview.h"
#include "toolbox_frame.h"

class ToolboxPoint : public os::Control
{
public:
	ToolboxPoint( const os::Rect& cFrame, os::String label, os::String entry_1, os::String entry_2, os::Message* msg = NULL, bool allow_rel = false,
				   uint32 nResizeMask = os::CF_FOLLOW_LEFT | os::CF_FOLLOW_TOP,
			       uint32 nFlags = os::WID_WILL_DRAW | os::WID_CLEAR_BACKGROUND | os::WID_FULL_UPDATE_ON_RESIZE );
	~ToolboxPoint();

	virtual void AllAttached( void );
	virtual void HandleMessage( os::Message* msg );
	virtual os::Point GetPreferredSize( bool bLargest ) const;
	void SetFrame( const os::Rect& cRect, bool bNotifyServer = true );

	void EnableStatusChanged( bool f ) {};
	void SetValue( os::Point point );
	void ClearValue();

	void SetOrigin( os::Point p ) { m_Origin = p; };

private:
	enum ToolboxPointMessage { MSG_ENTRY1, MSG_ENTRY2, MSG_RELATIVE };

	void _Layout();
	bool _CheckEntryForPoint();
	void _InvokePoint( os::String value1, os::String value2 );

	os::String m_FrameLabel;
	float m_FontHeight;

	ToolboxFrame* m_Frame;
	os::TableView* m_Table;
	os::StringView* m_Label_1;
	SLTextView* m_Entry_1;
	os::StringView* m_Label_2;
	SLTextView* m_Entry_2;

	os::CheckBox* m_RelativeCoord;
	os::Point m_Origin;

	os::Message* m_theMessage;
};

#endif
