// oCADis (C)opyright 2006 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef __TOOLBOX_ACTION_H_
#define __TOOLBOX_ACTION_H_

#include <vector>

#include "toolbox_frame.h"
#include "toolbox_button.h"
#include "tableview.h"

class ToolboxAction : public ToolboxFrame
{
public:
	ToolboxAction( const os::Rect& cFrame, const os::String& cName, 
				   uint32 nResizeMask = os::CF_FOLLOW_LEFT | os::CF_FOLLOW_TOP,
 		           uint32 nFlags = os::WID_WILL_DRAW | os::WID_CLEAR_BACKGROUND );
	~ToolboxAction();

	void SetFrame( const os::Rect& cRect, bool bNotifyServer = true );

	void AddButton( os::String label, os::Image* bitmap, os::Message* msg, os::String description );

	void SetTarget( os::Handler* pcMessenger );

	virtual os::Point GetPreferredSize( bool bLargest ) const;

private:
	void Layout();

	std::vector< ToolboxButton* > m_ListOfActionButtons;	
	os::TableView* m_Table;
};

#endif

