// oCADis (C)opyright 2006 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include <util/message.h>
#include <gui/window.h>

#include "sidebar_toolbox.h"
#include "messages.h"
#include "common.h"

using namespace os;
using namespace std;

ToolboxSideBar :: ToolboxSideBar( const Rect& cFrame, uint32 nResizeMask, uint32 nFlags ) : SideBar( cFrame, "Toolbox", nResizeMask, nFlags )
{
	m_CurrentToolbox = NULL;

	// Fix layout
	Layout();
}

ToolboxSideBar :: ~ToolboxSideBar()
{

}

void ToolboxSideBar :: Layout()
{
	Rect cFrame = SideBar::GetFrame();

	if( m_CurrentToolbox != NULL )
		m_CurrentToolbox->SetFrame( ConvertFromParent( cFrame ) );

	SideBar::Layout();
}

void ToolboxSideBar :: AllAttached( void )
{
	SideBar::AllAttached();
}

void ToolboxSideBar :: HandleMessage( Message* pcMessage )
{

	switch( pcMessage->GetCode() )	//Get the message code from the message
	{		
		case MSG_TOOLBAR_TOOL:
			printf( "trjo\n" );
			break;
	}
}

void ToolboxSideBar :: SetToolbox( Toolbox* tool )
{
	if( m_CurrentToolbox != NULL )
		RemoveChild( m_CurrentToolbox );

	m_CurrentToolbox = tool;
	AddChild( tool );
	Layout();
	Flush();
}

