// oCADis (C)opyright 2006 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include <util/message.h>
#include <gui/window.h>

#include "sidebar_dialog.h"
#include "messages.h"
#include "main.h"
#include "common.h"

using namespace os;
using namespace std;

DialogSideBar :: DialogSideBar( const Rect& cFrame, uint32 nResizeMask, uint32 nFlags ) : SideBar( cFrame, "Dialog2", nResizeMask, nFlags )
{
	m_CurrentDialog = NULL;

	// Fix layout
	Layout();
}

DialogSideBar :: ~DialogSideBar()
{

}

void DialogSideBar :: Layout()
{
	Rect cFrame = SideBar::GetFrame();

	if( m_CurrentDialog != NULL )
		m_CurrentDialog->SetFrame( ConvertFromParent( cFrame ) );

	SideBar::Layout();
}

void DialogSideBar :: AllAttached( void )
{
	SideBar::AllAttached();
}

void DialogSideBar :: HandleMessage( Message* pcMessage )
{

	switch( pcMessage->GetCode() )	//Get the message code from the message
	{		
		case MSG_TOOLBAR_TOOL:
			printf( "trjo\n" );
			break;
	}
}

void DialogSideBar :: SetDialog( Dialog* dia )
{
	if( dia == m_CurrentDialog )
		return;

	if( m_CurrentDialog != NULL )
		RemoveChild( m_CurrentDialog );

	m_CurrentDialog = dia;
	m_CurrentDialog->Init( GET_DOCUMENT() );
	AddChild( dia );
	Invalidate();
	Layout();
	Flush();
}

void DialogSideBar :: SetDocument( Document* doc )
{
	if( m_CurrentDialog != NULL )
		m_CurrentDialog->SetDocument( doc );
}

