// oCADis (C)opyright 2006 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef __DIALOG_GUIDE_H__
#define __DIALOG_GUIDE_H__

#include <gui/button.h>
#include <gui/checkbox.h>
#include <gui/radiobutton.h>

#include "toolbox_frame.h"
#include "tableview.h"
#include "dialogs/dialog.h"

class DialogGuide : public Dialog
{
public:
	DialogGuide( DialogSideBar* parent );
	~DialogGuide();

	virtual void SetFrame( const os::Rect& cRect, bool bNotifyServer = true );
	virtual void HandleMessage( Canvas* canvas, Document* doc, os::Message* pcMessage );
	void AllAttached( void );
	void Init( Document* doc );

private:
	enum StyleMessage {	MSG_SNAP_ACTIVE, 
						MSG_ORTHO_NONE, MSG_ORTHO_VERT, MSG_ORTHO_HORIZ, MSG_ORTHO_BOTH,
						MSG_GRID_ACTIVE };

	void _Layout();

	// Snap frame
	ToolboxFrame* m_SnapFrame;
	os::TableView* m_SnapTable;
	os::CheckBox* m_SnapActive;

	// Ortho frame
	ToolboxFrame* m_OrthoFrame;
	os::TableView* m_OrthoTable;
	os::RadioButton* m_OrthoNone;
	os::RadioButton* m_OrthoHoriz;
	os::RadioButton* m_OrthoVert;
	os::RadioButton* m_OrthoBoth;

	// Grid frame
	ToolboxFrame* m_GridFrame;
	os::TableView* m_GridTable;
	os::CheckBox* m_GridActive;

	// The table
	os::TableView* m_Table;
};

#endif
