/*  libsyllable.so - the highlevel API library for Syllable
 *  Copyright (C) 2003 Syllable Team
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of version 2 of the GNU Library
 *  General Public License as published by the Free Software
 *  Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 *  MA 02111-1307, USA
 */

#ifndef __F_GUI_COLORREQUESTER_H__
#define __F_GUI_COLORREQUESTER_H__

#include <stdarg.h>

#include <vector>
#include <gui/image.h>
#include <util/string.h>
#include <gui/window.h>
#include <gui/bitmap.h>
#include <gui/stringview.h>
#include <gui/button.h>
#include <util/message.h>

namespace os
{
#if 0
} // Fool Emacs auto-indent
#endif

class Invoker;

/** 
 * \ingroup gui
 * \par Description:
 *
 * \sa
 * \author	
 *****************************************************************************/

class ColorRequester : public Window
{
public:
    ColorRequester( const String& cTitle, Color32 cColor );
   ~ColorRequester(); 

	void SetColor( Color32 cColor );

	virtual bool OkToQuit( );
   
	virtual void	HandleMessage( Message* pcMessage );
	int  Go();
	void Go( Invoker* pcInvoker );
private:
	class Private;
	Private *m;
};

}
#endif // __F_GUI_COLORREQUESTER_H__


