// oCADis (C)opyright 2006 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "canvas.h"
#include "bkgbitmap.h"

using namespace os;

BkgBitmap :: BkgBitmap( Bitmap* orig, Rect size )
{
	m_Bitmap = new Bitmap( (int) size.Width(), (int) size.Height(), CS_RGBA32, Bitmap::SHARE_FRAMEBUFFER );
	m_Position = size;

	// Copy the bitmap to the background
	int w = (int) size.Width() * 4;
	int h = (int) size.Height();
	unsigned char* src = orig->LockRaster() + orig->GetBytesPerRow() * (int) size.top + (int) ( size.left * 4.0f );
	unsigned char* dst = m_Bitmap->LockRaster();

	for( int i = 0 ; i < h ; i++ )
	{
		memcpy( dst, src, w );
		src += orig->GetBytesPerRow();
		dst += m_Bitmap->GetBytesPerRow();
	}
}

BkgBitmap :: ~BkgBitmap()
{
	delete m_Bitmap;
}

void BkgBitmap :: Restore( Bitmap* to )
{
	// Copy the background to the bitmap
	int w = (int) m_Position.Width() * 4;
	int h = (int) m_Position.Height();
	unsigned char* src = m_Bitmap->LockRaster();
	unsigned char* dst = to->LockRaster() + to->GetBytesPerRow() * (int) m_Position.top + (int) ( m_Position.left * 4.0f );

	for( int i = 0 ; i < h ; i++ )
	{
		memcpy( dst, src, w );
		src += m_Bitmap->GetBytesPerRow();
		dst += to->GetBytesPerRow();
	}
}

