// oCADis (C)opyright 2006 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "toolbox_value.h"

using namespace os;

ToolboxValue :: ToolboxValue( const Rect& cFrame, String label, String entry, Message* msg, uint32 nResizeMask, uint32 nFlags) :
				Control( cFrame, "", "", msg, nResizeMask, nFlags )
{
	m_theMessage = msg;
	m_FrameLabel = label;

	// Calculate font height
	font_height tmp;	
	GetFontHeight( &tmp );
	m_FontHeight = tmp.ascender + tmp.descender;

	// Create the frame view
	m_Frame = new ToolboxFrame( Rect(), "", label );
	AddChild( m_Frame );

	// Create table and attach our widgets
	m_Table = new TableView( cFrame, "", 2, 1, false, CF_FOLLOW_ALL );
	m_Table->SetRowSpacings( 2 );
	m_Frame->AddChild( m_Table );

	m_Label = new StringView( Rect(), "", entry );
	m_Table->Attach( m_Label, 0, 1, 0, 1, 0, 0 );

	m_Entry = new SLTextView( Rect(), "", new Message( MSG_ENTRY ) );
	m_Entry->SetTarget( this );
	m_Table->Attach( m_Entry, 1, 2, 0, 1, ( TABLE_EXPAND | TABLE_FILL ), 0 );

	Layout();
}

ToolboxValue :: ~ToolboxValue()
{
	delete m_Frame;
	delete m_Label;
	delete m_Entry;
	delete m_Table;
}

void ToolboxValue :: AllAttached( void )
{
	m_Entry->SetTarget( this );
}

void ToolboxValue :: HandleMessage( Message* msg )
{
	if( msg->GetCode() == MSG_ENTRY )
	{	
		float value = atof( m_Entry->GetText().c_str() );;
		
		m_theMessage->RemoveName("value" );
		m_theMessage->AddFloat( "value", value );

		Invoke( m_theMessage );
	}
}

void ToolboxValue :: SetFrame( const Rect& cRect, bool bNotifyServer )
{
	View::SetFrame( cRect, bNotifyServer );
	Layout();
}

void ToolboxValue :: Layout()
{
	m_Frame->SetFrame( GetBounds() );
	Rect cFrame = ConvertFromParent( GetFrame() );	
	cFrame.Resize( 5, m_FontHeight + 5 , -5, -2 );
	m_Table->SetFrame( cFrame );
}

Point ToolboxValue :: GetPreferredSize( bool bLargest ) const
{
	if( bLargest )
	return Point( COORD_MAX, COORD_MAX );

	Point table = m_Table->GetPreferredSize( false );

	return Point( table.x + 3, table.y + m_FontHeight + 11);
}

void ToolboxValue :: SetValue( float value )
{
	// If any of the entries has focus we do not allow the new value to be valid
	if( m_Entry->HasFocus()  )
		return;

	String t;

	t.Format( "%f", value );
	m_Entry->SetText( t );

}

void ToolboxValue :: ClearValue()
{
	// If any of the entries has focus we do not allow the new value to be valid
	if( m_Entry->HasFocus() )
		return;

	m_Entry->Clear();
}

