// oCADis (C)opyright 2006 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef __TOOLBOX_NAVIGATION_H_
#define __TOOLBOX_NAVIGATION_H_

#include <vector>

#include "sidebar_toolbox.h"
#include "toolbox_frame.h"
#include "toolbox_button.h"
#include "tableview.h"
#include "toolbox.h"
#include "state.h"

class ToolboxNavigation : public ToolboxFrame
{
public:
	ToolboxNavigation( const os::Rect& cFrame, const os::String& cName, ToolboxSideBar* toolbox = NULL,
				   uint32 nResizeMask = os::CF_FOLLOW_LEFT | os::CF_FOLLOW_TOP,
 		           uint32 nFlags = os::WID_WILL_DRAW | os::WID_CLEAR_BACKGROUND );
	~ToolboxNavigation();

	virtual void SetFrame( const os::Rect& cRect, bool bNotifyServer = true );
	virtual os::Point GetPreferredSize( bool bLargest ) const;
	virtual void HandleMessage( os::Message* pcMessage );
	virtual void AllAttached( void );

	void AddButton( os::String label, os::Image* bitmap, os::String description, Toolbox* box );
	void AddButton( os::String label, os::Image* bitmap, os::String description, State* state );

private:
	void AddButton( os::String label, os::Image* bitmap, os::String description, os::Message* msg );
	void AddButton( os::String label, os::Image* bitmap, os::String description, os::Message* msg, Toolbox* box );
	
	enum ToolboxNavigationMessage { MSG_TOOLBOX, MSG_MAIN_TOOLBOX, MSG_CREATE_TOOLBOX };

	ToolboxSideBar* m_Toolbox;

	void Layout();

	std::vector< ToolboxButton* > m_ListOfActionButtons;	
	os::TableView* m_Table;
};

#endif

