// oCADis (C)opyright 2006 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef __TOOLBOX_H__
#define __TOOLBOX_H__

#include <gui/view.h>

#include "canvas.h"
#include "document.h"

class ToolboxSideBar;

class Toolbox : public os::View
{
public:
	Toolbox( ToolboxSideBar* parent );
	~Toolbox();

	void MouseUp( const os::Point& cPosition, uint32 nButtons, os::Message* pcData );

	virtual void Layout();
	void HandleMessage( os::Message* msg );
	virtual void HandleMessage( Canvas* canvas, Document* doc, os::Message* msg );

	void SetToolbox( Toolbox* tool );
	void SetMainToolbox();

private:
	void ClearFocus( os::View* parent );

	ToolboxSideBar* m_Parent;
};

#endif


