// oCADis (C)opyright 2006 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "tool_rotate_state_1.h"
#include "common.h"
#include "tool_rotate/tool_rotate.h"
#include "toolbox_button.h"
#include "toolbox_point.h"
#include "toolbox_action.h"
#include "tableview.h"

using namespace os;

///////////////////////////////////////////////////////////////////////////////
//
// P R I V A T E
//
///////////////////////////////////////////////////////////////////////////////

class RotateState1 :: Private
{
public:
	Private(){};

	void _Layout( Rect cFrame )
	{
		m_Table->SetFrame( Rect( 0, 0, cFrame.Width(), cFrame.Height() ) );
	}

	enum RotateState1Message { MSG_POINT, MSG_CENTER, MSG_CANCEL };

	ToolboxPoint* m_BasePoint;
	ToolboxAction* m_Action;

	TableView* m_Table;
};

///////////////////////////////////////////////////////////////////////////////
//
// T H E   C L A S S
//
///////////////////////////////////////////////////////////////////////////////
RotateState1 :: RotateState1( Tool* theTool, ToolboxSideBar* toolbox ) : ToolState( theTool, toolbox )
{
	// Create the private class
	m = new Private();

	// Create the table
	m->m_Table = new TableView( Rect(), "", 1, 3, false );
	m->m_Table->SetRowSpacings( 4 );
	AddChild( m->m_Table );

	// Create buttons and attach them to table
	m->m_BasePoint = new ToolboxPoint( Rect(), "Base point", "X: ", "Y: ", new Message( Private::MSG_POINT ) );
	m->m_Table->Attach( m->m_BasePoint, 0, 1, 0, 1, ( TABLE_EXPAND | TABLE_FILL ), 0 );

	m->m_Action = new ToolboxAction( Rect(), "" );
	m->m_Table->Attach( m->m_Action, 0, 1, 1, 2, ( TABLE_EXPAND | TABLE_FILL ), ( TABLE_EXPAND | TABLE_FILL ) );

	// Add action items
	m->m_Action->AddButton( "Center", (Image*) LoadImage( "circle.png" ), new Message( Private::MSG_CENTER ), "Choose the centerpoint of the selection " );
	m->m_Action->AddButton( "Cancel", (Image*) LoadImage( "cancel.png" ), new Message( Private::MSG_CANCEL ) , "Cancel the tool and return to main toolbox " );

	State::SetToolbox( this );
}

RotateState1 :: ~RotateState1()
{
	delete m;
}

void RotateState1 :: GotFocus( Canvas* canvas, Document* doc, Point coord )
{
	m->m_BasePoint->SetValue( coord );
}

void RotateState1 :: LostFocus( Canvas* canvas, Document* doc, Point coord )
{
	canvas->Undraw();
	m->m_BasePoint->ClearValue();
}

void RotateState1 :: MouseMove( Canvas* canvas, Document* doc, Point coord )
{
	canvas->Undraw();
	m->m_BasePoint->SetValue( coord );
}

String RotateState1 :: GetStatusText()
{
	return String( "Select base point of the rotation" );
}

void RotateState1 :: PointSelected( Canvas* canvas, Document* doc, Point coord )
{
	canvas->Undraw();

	GetTool()->SetProperty( "origin", Variant( coord ) );
	GetTool()->SetState( 2 );
}


void RotateState1 :: SetFrame( const Rect& cRect, bool bNotifyServer )
{
	Toolbox::SetFrame( cRect, bNotifyServer );
	m->_Layout( GetFrame() );
}

void RotateState1 :: AllAttached( void )
{
	Toolbox::AllAttached();

	m->m_BasePoint->SetTarget( this );
	m->m_Action->SetTarget( this );
}

void RotateState1 :: HandleMessage( Canvas* canvas, Document* doc, Message* pcMessage )
{
	switch( pcMessage->GetCode() )
	{	
	case Private::MSG_CANCEL:
		SetMainToolbox();
		break;
	case Private::MSG_CENTER:
	{		
		// Get center of selection
		Rect b = doc->GetSelectedBoundingBox();
		Point cen( ( b.right - b.left ) / 2.0f + b.left, ( b.bottom - b.top ) / 2.0f + b.top );
		PointSelected( canvas, doc, cen );
		break;
	}
	case Private::MSG_POINT:
		{
			Point p;

			if( pcMessage->FindPoint( "value", &p ) == EOK )
				PointSelected( canvas, doc, p );
			break;
		}
	}
}
