// oCADis (C)opyright 2006 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include <util/application.h>
#include "tool_erase_state_0.h"

using namespace os;

EraseState0 :: EraseState0( Tool* theTool, ToolboxSideBar* toolbox ) : StateMultiSelect( theTool, toolbox )
{

}

EraseState0 :: ~EraseState0()
{
}

String EraseState0 :: GetStatusText()
{
	return String( "Select objects to erase. Use Shift to select multiple objects" );
}

void EraseState0 :: SelectionDone( Canvas* canvas, Document* doc )
{
	UndoEraseObjects* undo = new UndoEraseObjects( "Erase" );

	// Erase all selected object
	for( int i = 0 ; i < doc->GetNoSelectedObjects() ; i++ )
	{
		Object* obj = doc->GetSelectedObject( i );
		obj->SetSelected( false );
		obj->Erase( canvas );
		undo->AddObject( obj );
		doc->RemoveObject( obj );
	}

	doc->AddUndoAction( undo );

	doc->DeselectAllObjects();
	SetMainToolbox();
}
