// oCADis (C)opyright 2006 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include <math.h>

#include "tool_circle_state_6.h"
#include "common.h"
#include "object_circle.h"

using namespace os;

///////////////////////////////////////////////////////////////////////////////
//
// P R I V A T E
//
///////////////////////////////////////////////////////////////////////////////

class CircleState6 :: _Private
{
public:
	_Private(){};

	void _Layout( Rect cFrame )
	{
		m_Table->SetFrame( Rect( 0, 0, cFrame.Width(), cFrame.Height() ) );
	}

	enum CircleState6Message { MSG_POINT, MSG_CANCEL };
	
	ToolboxPoint* m_SecondPoint;
	ToolboxAction* m_Action;

	os::TableView* m_Table;
};

///////////////////////////////////////////////////////////////////////////////
//
// T H E   C L A S S
//
///////////////////////////////////////////////////////////////////////////////
CircleState6 :: CircleState6( ToolCircle* theTool, ToolboxSideBar* toolbox ) : ToolState( theTool, toolbox )
{
	// Create the private class
	m = new _Private();

	// Create the table
	m->m_Table = new TableView( Rect(), "", 1, 2, false );
	m->m_Table->SetRowSpacings( 4 );
	AddChild( m->m_Table );

	// Create buttons and attach them to table
	m->m_SecondPoint = new ToolboxPoint( Rect(), "Second point", "X: ", "Y: ", new Message( _Private::MSG_POINT ), true );
	m->m_Table->Attach( m->m_SecondPoint, 0, 1, 0, 1, ( TABLE_EXPAND | TABLE_FILL ), 0 );

	m->m_Action = new ToolboxAction( Rect(), "" );
	m->m_Table->Attach( m->m_Action, 0, 1, 1, 2, ( TABLE_EXPAND | TABLE_FILL ), ( TABLE_EXPAND | TABLE_FILL ) );

	// Add action items
	m->m_Action->AddButton( "Cancel", (Image*) LoadImage( "cancel.png" ), new Message( _Private::MSG_CANCEL ) , "Cancel the tool and return to main toolbox " );

	State::SetToolbox( this );
}

CircleState6 :: ~CircleState6()
{	
	delete m;
}

void CircleState6 :: Init( Canvas* canvas, Document* doc )
{
	m->m_SecondPoint->SetOrigin( GetTool()->GetPropertyAsPoint( "first_point" ) );
	canvas->PrepareForXORMode();
}

void CircleState6 :: GotFocus( Canvas* canvas, Document* doc, Point coord )
{
	coord = doc->MakeSnap( GetTool()->GetPropertyAsPoint( "first_point" ), coord );
	m->m_SecondPoint->SetValue( coord );
}

void CircleState6 :: LostFocus( Canvas* canvas, Document* doc, Point coord )
{
	m->m_SecondPoint->ClearValue();
}

void CircleState6 :: MouseMove( Canvas* canvas, Document* doc, Point coord )
{
	coord = doc->MakeSnap( GetTool()->GetPropertyAsPoint( "first_point" ), coord );
	m->m_SecondPoint->SetValue( coord );

	canvas->SetStyle( doc->GetCurrentStyle() );
	canvas->DrawLine( GetTool()->GetPropertyAsPoint( "first_point" ), coord, true );
}

String CircleState6 :: GetStatusText()
{
	return String( "Select second point of the circle" );
}

void CircleState6 :: PointSelected( Canvas* canvas, Document* doc, Point coord )
{
	canvas->Undraw();
	coord = doc->MakeSnap( GetTool()->GetPropertyAsPoint( "first_point" ), coord );
	GetTool()->SetProperty( "second_point", coord );
	GetTool()->SetState( 7 );
}

void CircleState6 :: SetFrame( const Rect& cRect, bool bNotifyServer )
{
	Toolbox::SetFrame( cRect, bNotifyServer );
	m->_Layout( cRect );
}

void CircleState6 :: AllAttached( void )
{
	Toolbox::AllAttached();

	m->m_SecondPoint->SetTarget( this );
	m->m_Action->SetTarget( this );
}

void CircleState6 :: HandleMessage( Canvas* canvas, Document* doc, Message* pcMessage )
{
	switch( pcMessage->GetCode() )
	{
		case _Private::MSG_CANCEL:
			SetMainToolbox();
			break;
		case _Private::MSG_POINT:
			{
				Point p;

				if( pcMessage->FindPoint( "value", &p ) == EOK )
					PointSelected( canvas, doc, p );
		
				break;
			}
	}
}
