// oCADis (C)opyright 2006 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "tool_circle_state_0.h"
#include "common.h"

using namespace os;

///////////////////////////////////////////////////////////////////////////////
//
// P R I V A T E
//
///////////////////////////////////////////////////////////////////////////////

class CircleState0 :: _Private
{
public:
	_Private(){};

	void _Layout( Rect cFrame )
	{
		m_Table->SetFrame( Rect( 0, 0, cFrame.Width(), cFrame.Height() ) );
	}

	enum CircleState0Message { MSG_CLOSE, MSG_POINT, MSG_CANCEL, MSG_2P, MSG_3P };

	ToolboxPoint* m_CenterPoint;
	ToolboxAction* m_Action;

	os::TableView* m_Table;
};

///////////////////////////////////////////////////////////////////////////////
//
// T H E   C L A S S
//
///////////////////////////////////////////////////////////////////////////////
CircleState0 :: CircleState0( ToolCircle* theTool, ToolboxSideBar* toolbox ) : ToolState( theTool, toolbox )
{
	// Create the private class
	m = new _Private();

	// Create the table
	m->m_Table = new TableView( Rect(), "", 1, 2, false );
	m->m_Table->SetRowSpacings( 4 );
	AddChild( m->m_Table );

	// Create buttons and attach them to table
	m->m_CenterPoint = new ToolboxPoint( Rect(), "Center point", "X: ", "Y: ", new Message( _Private::MSG_POINT ) );
	m->m_Table->Attach( m->m_CenterPoint, 0, 1, 0, 1, ( TABLE_EXPAND | TABLE_FILL ), 0 );

	m->m_Action = new ToolboxAction( Rect(), "" );
	m->m_Table->Attach( m->m_Action, 0, 1, 1, 2, ( TABLE_EXPAND | TABLE_FILL ), ( TABLE_EXPAND | TABLE_FILL ) );

	// Add action items
	m->m_Action->AddButton( "Cancel", (Image*) LoadImage( "cancel.png" ), new Message( _Private::MSG_CANCEL ) , "Cancel the tool and return to main toolbox " );
	m->m_Action->AddButton( "2-P", (Image*) LoadImage( "circle.png" ), new Message( _Private::MSG_2P ) , "Draws a circle by specify two points on it " );
	m->m_Action->AddButton( "3-P", (Image*) LoadImage( "circle.png" ), new Message( _Private::MSG_3P ) , "Draws a circle by specify three points on it " );

	State::SetToolbox( this );
}

CircleState0 :: ~CircleState0()
{	
	delete m;
}

void CircleState0 :: GotFocus( Canvas* canvas, Document* doc, Point coord )
{
	coord = doc->MakeSnap( coord );
	m->m_CenterPoint->SetValue( coord );
}

void CircleState0 :: LostFocus( Canvas* canvas, Document* doc, Point coord )
{
	m->m_CenterPoint->ClearValue();
}

void CircleState0 :: MouseMove( Canvas* canvas, Document* doc, Point coord )
{
	coord = doc->MakeSnap( coord );
	m->m_CenterPoint->SetValue( coord );
}

String CircleState0 :: GetStatusText()
{
	return String( "Select center point of the circle" );
}

void CircleState0 :: PointSelected( Canvas* canvas, Document* doc, Point coord )
{
	coord = doc->MakeSnap( coord );
	GetTool()->SetProperty( "center_point", coord );
	GetTool()->SetState( 1 );
}

void CircleState0 :: SetFrame( const Rect& cRect, bool bNotifyServer )
{
	Toolbox::SetFrame( cRect, bNotifyServer );
	m->_Layout( cRect );
}

void CircleState0 :: AllAttached( void )
{
	Toolbox::AllAttached();

	m->m_CenterPoint->SetTarget( this );
	m->m_Action->SetTarget( this );
}

void CircleState0 :: HandleMessage( Canvas* canvas, Document* doc, Message* pcMessage )
{
	switch( pcMessage->GetCode() )
	{
		case _Private::MSG_2P:
			GetTool()->SetState( 3 );
			break;
		case _Private::MSG_3P:
			GetTool()->SetState( 5 );
			break;

		case _Private::MSG_CANCEL:
			SetMainToolbox();
			break;
		case _Private::MSG_POINT:
			{
				Point p;

				if( pcMessage->FindPoint( "value", &p ) == EOK )
					PointSelected( canvas, doc, p );
		
				break;
			}
	}
}

