// oCADis (C)opyright 2006 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "tool_arc.h"
#include "tool_arc_state_0.h"
#include "tool_arc_state_1.h"
#include "tool_arc_state_2.h"
#include "tool_arc_state_3.h"
#include "tool_arc_state_4.h"
#include "tool_arc_state_5.h"
#include "tool_arc_state_6.h"
#include "tool_arc_state_7.h"
#include "tool_arc_state_15.h"
#include "cadmath.h"

using namespace os;

ToolArc :: ToolArc( ToolboxSideBar* parent ) : Tool()
{
	AddState( new ArcState0( this, parent ) );
	AddState( new ArcState1( this, parent ) );
	AddState( new ArcState2( this, parent ) );
	AddState( new ArcState3( this, parent ) );
	AddState( new ArcState4( this, parent ) );
	AddState( new ArcState5( this, parent ) );
	AddState( new ArcState6( this, parent ) );
	AddState( new ArcState7( this, parent ) );
	AddState( new ArcState15( this, parent ) );
}

ToolArc :: ~ToolArc()
{
}

void ToolArc :: SetContinueArc( Document* doc, os::Point center, double radius, double start_angle, double end_angle )
{
	double d;
	double sx, sy;
	double bx, by;
	double ex, ey;
	double sangle, eangle;
	double tangent;

	sangle = start_angle;
	eangle = end_angle;

	// Find a point between start and end angle
	if( sangle  < eangle )
		sangle=(eangle-sangle)/2+sangle;
	else
	{
		sangle = ( 2.0f * M_PI - sangle + eangle ) / 2.0f + sangle;
		if( sangle > 2.0f * M_PI )
			sangle -= 2.0f * M_PI;
    }

	bx = center.x + radius * cos( sangle );
	by = center.y - radius * sin( sangle ); 

	sx = center.x + radius * cos( start_angle );
	sy = center.y - radius * sin( start_angle );
	ex = center.x + radius * cos( end_angle );
	ey = center.y - radius * sin( end_angle );

	d = CadMath::Distance( Point( sx, sx ), Point( ex, ey ) );

	if( ( ( sy - by ) * ( ex - sx ) -( sx - bx ) * ( ey - sy ) ) / ( d * d ) < 0 )	
		tangent = CadMath::GetAngle( center, Point( ex, ey ) );
	else
    	tangent = CadMath::GetAngle( Point( ex, ey ), center );

	doc->SetContinuePoint( Point( ex, ey ), tangent );
}
