// EFileBrowser	 (C)opyright 2006 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef __DIRENTRY_H__
#define __DIRENTRY_H__

#include <string>
#include <vector>

#include <gui/textview.h>
#include <gui/rect.h>
#include <gui/menu.h>
#include <util/string.h>
#include <util/message.h>
#include <util/invoker.h>
#include <gui/filerequester.h>

class SLTextView : public os::TextView
{
public:
	SLTextView( os::Rect cFrame, const os::String& cName, os::Message* pcMessage, bool do_automation = false, 
		  	    uint32 nResizeMask = os::CF_FOLLOW_LEFT | os::CF_FOLLOW_TOP,
			    uint32 nFlags = os::WID_WILL_DRAW | os::WID_CLEAR_BACKGROUND | os::WID_FULL_UPDATE_ON_RESIZE );

	~SLTextView();

	void SetTarget( os::Handler* pcMessenger );

  	virtual void KeyDown( const char* pzString, const char* pzRawString, uint32 nQualifiers );
	virtual void AttachedToWindow();
	virtual void MouseDown( const os::Point &cPosition, uint32 nButtons );
	virtual void HandleMessage( os::Message* msg );

	void SetText( os::String text ) { SetValue( text ); }
	os::String GetText() { return GetValue().AsString().Strip(); }
	os::Point GetPreferredSize( bool bLargest ) const;
	void SetMinWidth( float w ) { m_MinWidth = w; };

protected:
	bool TextSelected();

	enum { MSG_OPEN_BROWSER, MSG_CUT, MSG_COPY, MSG_PASTE, MSG_SELECT_ALL };

	bool m_Automation;
	float m_MinWidth;

	void DoAutoCompletion();
	std::string AutoCompletion( std::string& path );
	std::string CommonCharacters( std::vector<std::string>& valid_filenames );

	os::Message* m_theMessage;

	// Context menu
	os::Menu* m_ContextMenu;
	os::MenuItem* m_ContextBrowser;
	os::MenuItem* m_ContextCut;
	os::MenuItem* m_ContextCopy;
	os::MenuItem* m_ContextPaste;
	os::MenuItem* m_ContextSelectAll;

	// File requester
	os::FileRequester* m_Browser;

	// Invoker for the messages
	os::Invoker* m_Invoker;

};

#endif
