// oCADis (C)opyright 2007 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef __FILTER_OCADIS_H__
#define __FILTER_OCADIS_H__

#include <fstream>
#include <vector>

#include "filters/filter_base.h"

class FilteroCADis : public FilterBase
{
public:
	FilteroCADis() {};
	 ~FilteroCADis() {};

	bool Identify( os::String& path, os::String r );
	
	void Open( os::String& path, Document& doc );
	void Save( os::String& path, Document& doc );
private:
	bool _ReadLine( std::ifstream& fin, os::String& result );
	void _SplitLine( os::String line, std::vector< os::String >& split );
};

#endif
