// oCADis (C)opyright 2007 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include <util/string.h>
#include <util/message.h>
#include <util/variant.h>

#include "main.h"
#include "dialogs/dialog_osnap.h"
#include "windialogs/windia_alert.h"
#include "postoffice.h"
#include "messages.h"
#include "cadmath.h"
#include "common.h"

using namespace os;

DialogOSnap :: DialogOSnap( DialogSideBar* parent ) : Dialog( parent, String( "Object Snap" ) )
{
	// Create the table
	m_theTable = new TableView( Rect(), "", 2, 3, false );
	m_theTable->SetRowSpacings( 4 );
	AddChild( m_theTable );

	// Create the list
	m_OSnapList = new ListView( Rect(), "", ListView::F_RENDER_BORDER );
	m_OSnapList->SetAutoSort( true );
	m_OSnapList->SetMultiSelect( true );
	m_OSnapList->InsertColumn( "Name", 10 );
	m_OSnapList->SetHasColumnHeader( false );
	m_OSnapList->SetSelChangeMsg( new Message( MSG_SELECT ) );
	m_theTable->Attach( m_OSnapList, 0, 2, 0, 1, ( TABLE_EXPAND | TABLE_FILL ), ( TABLE_EXPAND | TABLE_FILL ) );

	// Create the settings frame
	m_SettingsFrame = new ToolboxFrame( Rect(0,0,100,100), "Settings", "Settings" );
//	m_theTable->Attach( m_SettingsFrame, 0, 2, 1, 2, ( TABLE_EXPAND | TABLE_FILL ), 0 );

	// Create settings table
	m_SettingsTable = new TableView( Rect(), "", 2, 2, false );
	m_SettingsTable->SetRowSpacings( 4 );
	m_SettingsTable->SetColumnSpacings( 6 );
	m_SettingsFrame->AddTableView( m_SettingsTable );

	// Create widgets in settings table
	m_SettingsLabel1 = new StringView( Rect(), "", "Distance:" );
	m_SettingsTable->Attach( m_SettingsLabel1, 0, 1, 0, 1, 0, 0 );
	m_SettingsDistance = new Slider( Rect(), "slider_distance", new Message( MSG_SLIDER_DISTANCE ) );
	m_SettingsTable->Attach( m_SettingsDistance, 1, 2, 0, 1, ( TABLE_EXPAND | TABLE_FILL ), 0 );

	m_SettingsLabel2 = new StringView( Rect(), "", "Sensitivity:" );
	m_SettingsTable->Attach( m_SettingsLabel2, 0, 1, 1, 2, 0, 0 );
	m_SettingsSensitivity = new Slider( Rect(), "slider_sensitivity", new Message( MSG_SLIDER_SENSITIVITY ) );
	m_SettingsTable->Attach( m_SettingsSensitivity, 1, 2, 1,2, ( TABLE_EXPAND | TABLE_FILL ), 0 );

	// Create the buttons
	m_SelectAll = new Button( Rect(), "", "Select all", new Message( MSG_SELECT_ALL ) );
	m_theTable->Attach( m_SelectAll, 0, 1, 2, 3, ( TABLE_EXPAND | TABLE_FILL ), 0, 4, 4 );

	m_DeselectAll = new Button( Rect(), "", "Deselect all", new Message( MSG_DESELECT_ALL ) );
	m_theTable->Attach( m_DeselectAll, 1, 2, 2, 3, ( TABLE_EXPAND | TABLE_FILL ), 0, 4, 4 );

	// Create content in the listview
	ListViewStringRow* row = new ListViewStringRow();
	row->AppendString( "End point" );
	row->SetCookie( OSNAP_ENDPOINT );
	m_OSnapList->InsertRow( row );	
	row = new ListViewStringRow();
	row->AppendString( "Mid point" );
	row->SetCookie( OSNAP_MIDPOINT );
	m_OSnapList->InsertRow( row );
	row = new ListViewStringRow();
	row->AppendString( "Center point" );
	row->SetCookie( OSNAP_CENPOINT );
	m_OSnapList->InsertRow( row );
	row = new ListViewStringRow();
	row->SetCookie( OSNAP_NEAPOINT );
	row->AppendString( "Nearest point" );
	m_OSnapList->InsertRow( row );
	row = new ListViewStringRow();
	row->SetCookie( OSNAP_QUAPOINT );
	row->AppendString( "Quadrant point" );
	m_OSnapList->InsertRow( row );

	_Layout();

	m_CurrentDocument = NULL;
}

DialogOSnap ::~DialogOSnap()
{
	delete m_theTable;
	delete m_OSnapList;

	// Settings
	delete m_SettingsFrame;
	delete m_SettingsTable;
	delete m_SettingsDistance;
	delete m_SettingsSensitivity;


	// Button
	delete m_SelectAll;
	delete m_DeselectAll;
}

void DialogOSnap :: SetFrame( const Rect& cRect, bool bNotifyServer )
{
	Dialog::SetFrame( cRect, bNotifyServer );
	_Layout();
}

void DialogOSnap :: AllAttached( void )
{
	Dialog::AllAttached();
	m_OSnapList->SetTarget( this );
	m_SelectAll->SetTarget( this );
	m_DeselectAll->SetTarget( this );
	m_SettingsDistance->SetTarget( this );
	m_SettingsSensitivity->SetTarget( this );

}

void DialogOSnap :: HandleMessage( Canvas* canvas, Document* doc, os::Message* pcMessage )
{
	switch( pcMessage->GetCode() )
	{
		case MSG_SELECT:
			_UpdateDocument( doc );
			break;
		case  MSG_SELECT_ALL:
			m_OSnapList->Select( 0, (int) m_OSnapList->GetRowCount() - 1 );
			_UpdateDocument( doc );
			break;
		case MSG_DESELECT_ALL:
			m_OSnapList->ClearSelection();
			_UpdateDocument( doc );
			break;
	}
}

void DialogOSnap :: Init( Document* doc )
{
	m_OSnapList->ClearSelection();

	if( doc == NULL )
		return;

	int osnap_mode = doc->GetOSnapMode();

	if( osnap_mode & OSNAP_ENDPOINT )
		_HighlightRow( OSNAP_ENDPOINT );

	if( osnap_mode & OSNAP_MIDPOINT )
		_HighlightRow( OSNAP_MIDPOINT );

	if( osnap_mode & OSNAP_CENPOINT )
		_HighlightRow( OSNAP_CENPOINT );

	if( osnap_mode & OSNAP_NEAPOINT )
		_HighlightRow( OSNAP_NEAPOINT );

	if( osnap_mode & OSNAP_QUAPOINT )
		_HighlightRow( OSNAP_QUAPOINT );

}

/////////////////////////////////////////////////////////////////////////////////////////////////////
//
// P R I V A T E   M E T H O D S
//
/////////////////////////////////////////////////////////////////////////////////////////////////////

void DialogOSnap :: _UpdateDocument( Document* doc )
{
	int mode = OSNAP_NONE;

	for( uint i = 0 ; i < m_OSnapList->GetRowCount() ; i++ )
	{
		ListViewRow* row = m_OSnapList->GetRow( i );
		
		if( row->IsSelected() )
		{
			mode |= (int) row->GetCookie().AsInt32();
		}
	}
	
	doc->SetOSnapMode( mode );
}

void DialogOSnap :: _HighlightRow( int mode )
{
	for( uint i = 0 ; i < m_OSnapList->GetRowCount() ; i++ )
	{
		ListViewRow* row = m_OSnapList->GetRow( i );
		
		if( row->GetCookie().AsInt32() == mode )
		{
			printf( "Highlife!\n" );
			m_OSnapList->Select( i );
		}
	}

	m_OSnapList->Invalidate();
	m_OSnapList->Flush();
}

void DialogOSnap :: _Layout()
{
	Rect cFrame = GetBounds();
	m_theTable->SetFrame( cFrame );
}



