// oCADis (C)opyright 2007 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef __DIALOG_LAYER_H__
#define __DIALOG_LAYER_H__

#include <gui/listview.h>
#include <gui/button.h>

#include "dialogs/dialog.h"
#include "windialogs/windia_addlayer.h"
#include "windialogs/windia_modifylayer.h"
#include "tableview.h"
#include "document.h"

class Document;

class DialogLayer : public Dialog
{
public:
	DialogLayer( DialogSideBar* parent );
	~DialogLayer();

	virtual void SetFrame( const os::Rect& cRect, bool bNotifyServer = true );
	virtual void HandleMessage( Canvas* canvas, Document* doc, os::Message* pcMessage );
	void AllAttached( void );

	void SetDocument( Document* doc );
private:
	void _UpdateLayers();
	void _SetCurrent();
	void _Up();
	void _Down();
	void _Delete();
	void _Invoke();

	enum LayerMessage { MSG_NEW, MSG_EDIT, MSG_DELETE, MSG_UP, MSG_CURRENT, MSG_DOWN, MSG_LISTVIEW_INVOKE };

	void _Layout();

	os::TableView* m_theTable;
	os::ListView* m_LayerList;
	os::Button* m_Up;
	os::Button* m_Current;
	os::Button* m_Down;
	os::Button* m_New;
	os::Button* m_Edit;
	os::Button* m_Delete;

	WinDiaAddLayer* m_WinDiaAddLayer;
	WinDiaModifyLayer* m_WinDiaModifyLayer;
};

#endif
