// oCADis (C)opyright 2006 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef __COLOUR_BUTTON_H__
#define __COLOUR_BUTTON_H__

#include <gui/button.h>
#include <gui/gfxtypes.h>
#include "colorrequester.h"

class ColourButton : public os::Button
{
public:
	ColourButton( const os::Rect& cFrame, os::Message* msg,
				   uint32 nResizeMask = os::CF_FOLLOW_LEFT | os::CF_FOLLOW_TOP,
			       uint32 nFlags = os::WID_WILL_DRAW | os::WID_CLEAR_BACKGROUND | os::WID_FULL_UPDATE_ON_RESIZE );
	~ColourButton();

	virtual void Paint( const os::Rect& cUpdate );

	virtual os::Point GetPreferredSize( bool bLargest ) const;

	virtual void HandleMessage( os::Message* pcMessage );
	void AllAttached( void );

	os::Color32_s GetColour() { return m_theColour; };
	void SetColour( os::Color32_s colour );
	void SetTarget( os::Handler* pcHandler );

private:
	enum ColourButtonMessage {	MSG_COLOUR, MSG_SELECTOR };

	// Invoker for the messages
	os::Invoker* m_Invoker;

	os::Color32_s m_theColour;
	os::ColorRequester* m_Selector;
};

#endif
