#include "colorrequester.h"
#include <gui/colorselector.h>
#include <gui/button.h>
#include <gui/layoutview.h>

using namespace os;

enum {
	ID_COLOR = 1,
	ID_OK,
	ID_CANCEL
};

class ColorRequester::Private
{
	public:
	ColorSelector*	m_pcColSel;
	Button*			m_pcOkButton;
	Button*			m_pcCancelButton;
    Invoker*   m_pcInvoker;
    port_id    m_hMsgPort;
};

ColorRequester::ColorRequester( const String& cTitle, Color32 cColor )
:Window( Rect( 0, 0, 350, 250 ), "requester_window", cTitle,
	/*WND_NOT_RESIZABLE | WND_NO_ZOOM_BUT | WND_NO_DEPTH_BUT*/ 0 )
{
	m = new Private;

	m->m_pcColSel = new ColorSelector( Rect( 0, 0, 1, 1 ), "", new Message( ID_COLOR ), cColor );
	m->m_pcOkButton = new Button( Rect(), "", "Ok", new Message( ID_OK ) );
	m->m_pcCancelButton = new Button( Rect(), "", "Cancel", new Message( ID_CANCEL ) );

	LayoutNode*	pcRootNode = new VLayoutNode( "pcRootNode" );
	LayoutNode*	pcButtonsNode = new HLayoutNode( "pcButtonsNode" );
	LayoutNode*	pcColViewNode = new HLayoutNode( "pcColViewNode", 100.0f );

	pcButtonsNode->AddChild( m->m_pcOkButton );
	pcButtonsNode->AddChild( m->m_pcCancelButton );

	pcColViewNode->AddChild( m->m_pcColSel );

	pcRootNode->AddChild( pcColViewNode );
	pcRootNode->AddChild( pcButtonsNode );

	LayoutView*	pcRootView = new LayoutView( GetBounds(), "pcRootView" );
	pcRootView->SetRoot( pcRootNode );
	AddChild( pcRootView );

	CenterInScreen();
	
	m->m_hMsgPort = -1;
}

ColorRequester::~ColorRequester()
{
	delete m;
}

void ColorRequester::SetColor( Color32 cColor )
{
	m->m_pcColSel->SetValue( cColor );
}

bool ColorRequester::OkToQuit( void )
{
/*	Message *pcMsg = new Message( M_FILE_REQUESTER_CANCELED );

	m->m_pcTarget->SendMessage( pcMsg );*/
	Show( false );
	return ( false );
}

void ColorRequester::HandleMessage( Message * pcMessage )
{
	switch( pcMessage->GetCode()  )
	{
		case ID_OK:
			if( m->m_hMsgPort >= 0 )
			{
				send_msg( m->m_hMsgPort, pcMessage->GetCode(), NULL, 0 );
			}
			else
			{
				if( m->m_pcInvoker != NULL )
				{
					Message *pcMsg = m->m_pcInvoker->GetMessage();
	
					if( pcMsg == NULL )
					{
						dbprintf( "Error: Invoker registered with this Color requester does not have a message!\n" );
					}
					else
					{
						pcMsg->AddColor32( "color", m->m_pcColSel->GetValue().AsColor32() );
						m->m_pcInvoker->Invoke();
					}
				}
				PostMessage( M_QUIT );
			}
			break;
		case ID_CANCEL:
			PostMessage( M_QUIT );
			break;
		case ID_COLOR:
			break;
		default:
			Handler::HandleMessage( pcMessage );
			break;
	}
}

int ColorRequester::Go()
{
	uint32 nCode;
	int nError;

	m->m_hMsgPort = create_port( "colreq_port", DEFAULT_PORT_SIZE );

	Show();
	MakeFocus();
	if( m->m_hMsgPort < 0 )
	{
		PostMessage( M_QUIT );
		return ( -1 );
	}
	nError = get_msg( m->m_hMsgPort, &nCode, NULL, 0 );
	if( nError < 0 )
	{
		PostMessage( M_QUIT );
		return ( -1 );
	}
	else
	{
		PostMessage( M_QUIT );
		return ( nCode );
	}
}

void ColorRequester::Go( Invoker * pcInvoker )
{
	m->m_pcInvoker = pcInvoker;
	Show();
	MakeFocus();
}















