// oCADis (C)opyright 2006 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef __CANVAS_H_
#define __CANVAS_H_

#include <vector>

#include <gui/view.h>
#include <gui/bitmap.h>

#include "layer.h"
#include "style.h"
#include "transform.h"

#include "canvasbitmap.h"

#include "bkgbitmap.h"

class AppWindow;
class Document;

class Canvas : public os::View
{
public:
	Canvas( AppWindow* parent, const os::Rect& cFrame, uint32 nResizeMask = os::CF_FOLLOW_LEFT | os::CF_FOLLOW_TOP );
	~Canvas();

	void WheelMoved( const os::Point& delta );

	void MouseUp( const os::Point& cPosition, uint32 nButtons, os::Message* pcData );
	void MouseDown( const os::Point& cPosition, uint32 nButtons );
	void MouseMove( const os::Point& cPosition, int nCode, uint32 nButtons, os::Message* pcData );

	virtual void AttachedToWindow();
	virtual void Paint( const os::Rect& cUpdate );
	virtual void FrameSized( const os::Point& delta );
	virtual os::Point GetPreferredSize( bool bLargest ) const;

	inline os::Point ScreenToWorld( os::Point p );
	inline os::Point WorldToScreen( os::Point p );
	inline float WorldToScreen( float value );
	inline float ScreenToWorld( float value );
	
	void SetStyle( Style& style );
	void SetDefaultStyle();

	void SetColour( double r, double b, double g );
	void SetLineWidth( double width );
	void SetAntiAlias( bool use );

	void Refresh();

	void Undraw() { _RestoreBackground(); };

	// Draw functions
	void DrawSelectedObjects( Transform& transform );

	void DrawLine( os::Point p1, os::Point p2, bool save_background = false, bool update_server = true );
	void DrawRectangle( os::Rect r, bool save_background = false, bool update_server = true );
	void DrawCircle( os::Point center, float radiu, bool save_background = false, bool update_server = true );
	void DrawArc( os::Point center, float radius, float start_angle, float end_angle, bool save_background = false, bool update_server = true );
	void DrawGrid( Document* doc );

	void GetViewport( os::Point& p, double& z ) { p = m_Pan; z = m_ZoomFactor; };
	void SetViewport( os::Point p, double z ) { m_Pan = p; m_ZoomFactor = z; };
	os::Rect GetViewPortSize();

	os::String Save();

	void ZoomBox( os::Rect bounds );

	void PrepareForXORMode();

	void UndrawOSnap();

private:
	void _CreateBitmap();	
	void _DrawGridNegative( Document* doc );
	void _DrawGridPositive( Document* doc );
	
	std::vector< os::Rect > m_ListofDirtyRects;
	void _SaveBackground( os::Rect size );
	void _RestoreBackground();

	AppWindow* m_Parent;

	// Where to draw
	CanvasBitmap* m_CurrentBitmapView;  // what you see on the screen
	CanvasBitmap* m_DocumentBitmapView; // bitmap of the drawing

	// Zooming
	os::Point m_Pan;
	float m_ZoomFactor;

	// OSnap point
	bool m_SnapDrawn;
	os::Rect m_SnapPosition;
	bool m_SnapMouse;
	
	bool m_MousePressed;
	bool m_MouseSelecting;
	bool m_WantsToPan;
	bool m_WantsMouseBox;
	os::Point m_PanStart;
	os::Point m_SelectStart;
	os::Point m_LastSelectPosition;
};

#endif
