// oCADis (C)opyright 2007 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef __WINDIA_PAGESETUP_H__
#define __WINDIA_PAGESETUP_H__

#include <gui/window.h>
#include <gui/button.h>
#include <gui/checkbox.h>
#include <gui/textview.h>
#include <gui/stringview.h>
#include <gui/dropdownmenu.h>
#include <util/string.h>
#include <util/message.h>
#include "tableview.h"
#include "toolbox_frame.h"
#include "colour_button.h"
#include "document.h"

class WinDiaPageSetup : public os::Window
{
public:
	enum messages { MSG_OK, MSG_CANCEL };

	WinDiaPageSetup( const os::Rect& cFrame, Document* current );
	~WinDiaPageSetup();

	virtual void HandleMessage( os::Message* pcMessage );	
	virtual bool OkToQuit( void );
	virtual void FrameSized( const os::Point& delta );
	
	void Raise();

private:

	void _Layout();

	Document* m_CurrentDocument;

	os::TableView* m_theTable;

	// Attributes
	ToolboxFrame* m_AttrFrame;
	os::TableView* m_AttrTable;

	os::StringView* m_LabelName;
	os::TextView* m_Name;

	os::CheckBox* m_Visible;
	os::CheckBox* m_Editable;

	// Style
	ToolboxFrame* m_StyleFrame;
	os::TableView* m_StyleTable;

	os::StringView* m_LabelColour;
	ColourButton* m_Colour;

	os::StringView* m_LabelLinewidth;
	os::TextView* m_Linewidth;
	
	os::StringView* m_LabelPattern;
	os::DropdownMenu* m_Pattern;

	// Button bar
	os::TableView* m_ButtonTable;
	os::Button* m_OK;
	os::Button* m_Cancel;
};

#endif


