// oCADis (C)opyright 2007 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "windialogs/windia_about.h"
#include "common.h"

using namespace os;

WinDiaAbout :: WinDiaAbout() : Window( Rect(), "about_ocadis", "About oCADis", WND_NO_ZOOM_BUT | WND_NO_DEPTH_BUT | WND_NOT_RESIZABLE )
{
	// Create layout
	pcLayoutView = new LayoutView( Rect(), "" );
	AddChild( pcLayoutView );

	// Create basepanel	
	pcRoot = new VLayoutNode( "" );
	pcRoot->SetVAlignment( os::ALIGN_CENTER );
	pcRoot->SetHAlignment( os::ALIGN_CENTER );
	pcLayoutView->SetRoot( pcRoot );

	// Create the oCADis image
	pcoCADisImageView = new ImageView( Rect(), "ocadis_image", LoadImage( "about.png" ) );
	pcRoot->AddChild( pcoCADisImageView );

	pcRoot->AddChild( new VLayoutSpacer( "", 8, 8 ) );

	// Create version label
	pcVersionLabel = new StringView( Rect(), "version_label", "Version: 0.0.1", ALIGN_RIGHT );
	pcRoot->AddChild( pcVersionLabel );
	Font* f = pcVersionLabel->GetFont();
	f->SetSize( 8 );
	pcVersionLabel->SetFont( f );

	pcRoot->AddChild( new VLayoutSpacer( "", 6, 6 ) );

	// Create syllable label
	pcTextEditorLabel = new StringView( Rect(), "texteditor_label", "A 2D CAD for Syllable", ALIGN_CENTER );
	pcRoot->AddChild( pcTextEditorLabel );

	pcRoot->AddChild( new VLayoutSpacer( "", 4, 4 ) );

	pcTextEditorLabel = new StringView( Rect(), "texteditor_label", "(c)2007 Jonas Jarvoll - Released under GPL", ALIGN_CENTER );
	pcRoot->AddChild( pcTextEditorLabel );

	pcRoot->AddChild( new VLayoutSpacer( "", 4, 4 ) );

	pcTextEditorLabel = new StringView( Rect(), "texteditor_label", "http://www.jarvoll.se/syllable", ALIGN_CENTER );
	pcRoot->AddChild( pcTextEditorLabel );

	pcRoot->AddChild( new VLayoutSpacer( "", 8, 8 ) );

	// Create close button
	pcCloseButton = new Button( Rect(), "close_button", "Close", new Message( MSG_CLOSE ) );
	pcCloseButton->SetTarget( this );
	pcRoot->AddChild( pcCloseButton );
	SetDefaultButton( pcCloseButton );
	
	// Set size of window
	Point size = pcLayoutView->GetPreferredSize( false );
	ResizeTo( size.x + 20, size.y + 20 );
	CenterInScreen();

	// Close dialog with escape
	ShortcutKey s( VK_ESCAPE ); 
	AddShortcut( s, new Message( MSG_CLOSE ) );
}

WinDiaAbout :: ~WinDiaAbout()
{

}

void WinDiaAbout :: HandleMessage(Message* pcMessage)
{
	if( pcMessage->GetCode() == MSG_CLOSE )
		_Close();
}

bool WinDiaAbout :: OkToQuit()
{
	_Close();
	return false;
}

void WinDiaAbout :: Raise()
{
	if( IsVisible() )
		Show( false );

	Show( true );

	MakeFocus();
}

void WinDiaAbout :: FrameSized( const Point& cDelta )
{
	Window::FrameSized( cDelta );

	Rect cFrame = GetBounds();
	cFrame.Resize( 2, 2, -2, -2 );
	pcLayoutView->SetFrame( cFrame );	
}

///////////////////////////////////////////////////////////////////////////////////////////////////
//
// P R I V A T E
//
///////////////////////////////////////////////////////////////////////////////////////////////////

void WinDiaAbout :: _Close()
{
	// Close the About window
	Hide();
}
