// oCADis (C)opyright 2006 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef __TOOL_H__
#define __TOOL_H__

#include <vector>
#include <map>
#include <util/variant.h>
#include <util/string.h>

#include "toolbox.h"
#include "state.h"

class State;

class Tool
{
public:
	Tool();
	virtual ~Tool();

	void AddState( State* state );
	State* GetState( int no );
	void SetState( int no );

	virtual void Init( int state = 0 );

	virtual int InitState() { return 0; };
	virtual os::String Name() { return os::String( "no name" ); };
	virtual os::String Image() { return os::String( "close.png" ); };
	virtual os::String Description() { return os::String( "no desc" ); };

	virtual bool SetProperty( os::String s, os::Variant value );
	virtual bool GetProperty( os::String s, os::Variant& value );
	virtual double GetPropertyAsDouble( os::String s );
	virtual os::Point GetPropertyAsPoint( os::String s );

private:
	std::vector< State* > m_ListOfStates;
	std::map< os::String, os::Variant > m_Memory;
};

#endif
