// oCADis (C)opyright 2006 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "tool.h"
#include "main.h"

using namespace os;
using namespace std;

Tool :: Tool() 
{
}

Tool :: ~Tool()
{
	for( uint i = 0 ; i < m_ListOfStates.size() ; i++ )
		delete m_ListOfStates[ i ];
}

void Tool :: AddState( State* state ) 
{ 
	m_ListOfStates.push_back( state ); 
}

State* Tool :: GetState( int no )
{ 
	return m_ListOfStates.at( no );
}

void Tool :: Init( int state )
{
	SetState( state );
}

void Tool :: SetState( int no )
{
	try
	{
		GET_CANVAS()->Undraw();
		SET_STATE( m_ListOfStates.at( no ) );
	}
	catch( ... )
	{
		printf( "Unable to set to state %d (unimplemented state?)\n", no );
	}
}

bool Tool :: SetProperty( String s, Variant value )
{
	m_Memory[ s ] = value;
	return true;
}

bool Tool :: GetProperty( String s, Variant& value )
{
	value = m_Memory[ s ];
 
	return false;
}

double Tool :: GetPropertyAsDouble( String s )
{
	Variant value = m_Memory[ s ];

	return value.AsDouble();
}

Point Tool :: GetPropertyAsPoint( String s )
{
	Variant value = m_Memory[ s ];

	return value.AsPoint();
}
