// oCADis (C)opyright 2006 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef __SIDEBAR_TOOLBOX_H__
#define __SIDEBAR_TOOLBOX_H__

#include <vector>

#include "sidebar.h"
#include "toolbox_button.h"

#include "toolbox.h"

class ToolboxSideBar : public SideBar
{
public:
	ToolboxSideBar( const os::Rect& cFrame, uint32 nResizeMask = os::CF_FOLLOW_LEFT | os::CF_FOLLOW_TOP,
			       uint32 nFlags = os::WID_WILL_DRAW | os::WID_CLEAR_BACKGROUND | os::WID_FULL_UPDATE_ON_RESIZE );
	~ToolboxSideBar();

	virtual void HandleMessage( os::Message* pcMessage );
	virtual void AllAttached( void );

	void SetToolbox( Toolbox* tool );

protected:
	virtual void Layout();

private:
	Toolbox* m_CurrentToolbox;
};

#endif

