// oCADis (C)opyright 2006 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef __PROMPT_H_
#define __PROMPT_H_

#include <util/string.h>
#include <gui/view.h>
#include <gui/stringview.h>
#include <gui/textview.h>
#include "sltextview.h"

class Prompt : public os::View
{
public:
	Prompt( os::Rect cFrame, const os::String& cName, os::Message* pcMessage,
			uint32 nResizeMask = os::CF_FOLLOW_LEFT | os::CF_FOLLOW_TOP,
			uint32 nFlags = os::WID_WILL_DRAW | os::WID_CLEAR_BACKGROUND );

	~Prompt();

	void SetPrompt( os::String prompt );	
	void Print( os::String p );

	void FrameSized( const os::Point& cDelta );
	void SetFrame( const os::Rect& cRect, bool bNotifyServer = true );
	os::Point GetPreferredSize( bool bLargest );


private:
	void Layout();

	os::Message* m_theMessage;

	os::StringView* m_Prompt;
	SLTextView* m_Entry;
	os::TextView* m_Output;
};

#endif

