// oCADis (C)opyright 2006 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "pattern.h"

using namespace os;
using namespace std;

Pattern :: Pattern( os::String name, int count, ... )
{
	m_Name = name;
	m_Scale = 1.0f;
	m_Offset = 0.0f; 
	m_AllowZooming = true;
	
	// Add dashes
	va_list ap;
	va_start(ap, count);
	for( int i = 0 ; i < count ; i++ ) 
		AddPattern( va_arg(ap, double) );

    va_end(ap);
}


// S, [name], [offset], [scale], [number of dashes ], [ all dashes ]
String Pattern :: Save()
{
	String d;

	d.Format( "P, \"%s\", %f, %f, %d", GetName().c_str(), GetOffset(), GetScale(), GetDashesCount() );
	
	for( int i = 0 ; i < GetDashesCount() ; i++ )
	{
		String tmp;

		tmp.Format( ", %f", GetDash( i ) );

		d = d + tmp;
	}

	d += "\n";

	return d;
}
 
