// EFileBrowser	 (C)opyright 2006 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef __MESSAGES_H_
#define __MESSAGES_H_

enum Messages
{
	// Sidebar
	MSG_SIDEBAR_HIDE = 0,

	// Toolbar
	MSG_TOOLBAR_TOOL,

	// Menu
	///////////////////////////////

	// App
	MSG_MENU_ABOUT = 100,
	MSG_MENU_QUIT,

	// File
	MSG_MENU_NEW = 200,
	MSG_MENU_OPEN,
	MSG_MENU_CLOSE,
	MSG_MENU_SAVE,
	MSG_MENU_SAVEAS,
	MSG_MENU_EXPORT,
	MSG_MENU_PAGESETUP,
	MSG_MENU_PRINT,

	// Edit
	MSG_MENU_UNDO = 300,
	MSG_MENU_REDO,

	// View
	MSG_MENU_LAYER = 400,
	MSG_MENU_STYLE,
	MSG_MENU_GUIDE,
	MSG_MENU_OSNAP,
	MSG_MENU_HIDE,
	MSG_MENU_TOOLBOX,
	MSG_MENU_REFRESH,
	MSG_MENU_ZOOM_ALL,
	MSG_MENU_ZOOM_MODE,
	MSG_MENU_PAN_MODE,

	// Broadcast messages
	MSG_BROADCAST_NEW_DOCUMENT = 0x1234,	// Sent when the current document is changed (ie. by loading a file, by creating a new doc )
	MSG_BROADCAST_ADD_LAYER,
	MSG_BROADCAST_MODIFY_LAYER,
	MSG_BROADCAST_DELETE_LAYER,
	MSG_BROADCAST_ADD_OBJECT,
	MSG_BROADCAST_MODIFY_OBJECT,
	MSG_BROADCAST_DELETE_OBJECT,
	MSG_BROADCAST_UPDATE_UNDO,				// Sent when Undo info have been updated
	MSG_BROADCAST_UPDATE_TITLE,				// Sent when the title of the drawing needs to be updated (eg. if the drawing as been modified)

	// Misc messages
	MSG_EXPORT_REQUESTED = 0x2000,
	MSG_ALERT_QUIT,
	MSG_MAIN_TOOLBOX,

	// Used where no message is required
	MSG_VOID
};

#endif

