// oCADis (C)opyright 2006 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include <util/string.h>
#include <util/message.h>

#include "cadmath.h"
#include "dialogs/dialog_guide.h"

using namespace os;

DialogGuide :: DialogGuide( DialogSideBar* parent ) : Dialog( parent, String( "Guide" ) )
{
	// Create the table
	m_Table = new TableView( Rect(), "", 2, 4, false );
	m_Table->SetRowSpacings( 4 );
	AddChild( m_Table );

	// SNAP FRAME

	// Create the snap frame
	m_SnapFrame = new ToolboxFrame( Rect(0,0,100,100), "Snap", "Snap" );
	m_Table->Attach( m_SnapFrame, 0, 2, 0, 1, ( TABLE_EXPAND | TABLE_FILL ), 0 );

	// Create snap table
	m_SnapTable = new TableView( Rect(), "", 1, 2, false );
	m_SnapTable->SetRowSpacings( 4 );
	m_SnapFrame->AddTableView( m_SnapTable );

	// Create widgets in snap table
	m_SnapActive = new CheckBox( Rect(), "Active", "Active", new Message( MSG_SNAP_ACTIVE ) );
	m_SnapTable->Attach( m_SnapActive, 0, 1, 0, 1, ( TABLE_EXPAND | TABLE_FILL ), 0 );

	// ORTHO FRAME

	// Create the ortho frame
	m_OrthoFrame = new ToolboxFrame( Rect(0,0,100,100), "Ortho", "Ortho" );
	m_Table->Attach( m_OrthoFrame, 0, 2, 1, 2, ( TABLE_EXPAND | TABLE_FILL ), 0 );

	// Create ortho table
	m_OrthoTable = new TableView( Rect(), "", 1, 4, false );
	m_OrthoTable->SetRowSpacings( 4 );
	m_OrthoFrame->AddTableView( m_OrthoTable );

	// Create widgets in ortho table
	m_OrthoNone = new RadioButton( Rect(), "None", "None", new Message( MSG_ORTHO_NONE ) );
	m_OrthoTable->Attach( m_OrthoNone, 0, 1, 0, 1, ( TABLE_EXPAND | TABLE_FILL ), 0 );
	m_OrthoHoriz = new RadioButton( Rect(), "Horizontal", "Horizontal", new Message( MSG_ORTHO_HORIZ ) );
	m_OrthoTable->Attach( m_OrthoHoriz, 0, 1, 1, 2, ( TABLE_EXPAND | TABLE_FILL ), 0 );
	m_OrthoVert = new RadioButton( Rect(), "Vertical", "Vertical", new Message( MSG_ORTHO_VERT ) );
	m_OrthoTable->Attach( m_OrthoVert, 0, 1, 2, 3, ( TABLE_EXPAND | TABLE_FILL ), 0 );
	m_OrthoBoth = new RadioButton( Rect(), "Orthogonal", "Orthogonal", new Message( MSG_ORTHO_BOTH ) );
	m_OrthoTable->Attach( m_OrthoBoth, 0, 1, 3, 4, ( TABLE_EXPAND | TABLE_FILL ), 0 );

	// GRID FRAME

	// Create the snap frame
	m_GridFrame = new ToolboxFrame( Rect(0,0,100,100), "Grid", "Grid" );
	m_Table->Attach( m_GridFrame, 0, 2, 2, 3, ( TABLE_EXPAND | TABLE_FILL ), 0 );

	// Create grid table
	m_GridTable = new TableView( Rect(), "", 1, 1, false );
	m_GridTable->SetRowSpacings( 4 );
	m_GridFrame->AddTableView( m_GridTable );

	// Create widgets in grid table
	m_GridActive = new CheckBox( Rect(), "Active", "Active", new Message( MSG_GRID_ACTIVE ) );
	m_GridTable->Attach( m_GridActive, 0, 1, 0, 1, ( TABLE_EXPAND | TABLE_FILL ), 0 );
}

DialogGuide ::~DialogGuide()
{
	delete m_SnapFrame;
	delete m_SnapTable;
	delete m_SnapActive;

	delete m_OrthoNone;
	delete m_OrthoBoth;
	delete m_OrthoVert;
	delete m_OrthoHoriz;

	delete m_GridFrame;
	delete m_GridTable;
	delete m_GridActive;

	delete m_Table;
}

void DialogGuide :: SetFrame( const Rect& cRect, bool bNotifyServer )
{
	Dialog::SetFrame( cRect, bNotifyServer );
	_Layout();
}

void DialogGuide :: AllAttached( void )
{
	Dialog::AllAttached();

	m_SnapActive->SetTarget( this );
	m_OrthoNone->SetTarget( this );
	m_OrthoHoriz->SetTarget( this );
	m_OrthoVert->SetTarget( this );
	m_OrthoBoth->SetTarget( this );
	m_GridActive->SetTarget( this );
}

void DialogGuide :: HandleMessage( Canvas* canvas, Document* doc, os::Message* pcMessage )
{
	switch( pcMessage->GetCode() )
	{
		case MSG_SNAP_ACTIVE:
			doc->SetSnapActive( m_SnapActive->GetValue().AsBool() );
			break;
		case MSG_GRID_ACTIVE:
			doc->SetGridActive( m_GridActive->GetValue().AsBool() );
			canvas->DrawGrid( doc );
			canvas->PrepareForXORMode();  // We need to update the background as well
			canvas->Invalidate();
			canvas->Sync();
			break;
		case MSG_ORTHO_NONE:
			doc->SetOrthoMode( Document::OrthoNone );
			break;
		case MSG_ORTHO_BOTH:
			doc->SetOrthoMode( Document::OrthoBoth );
			break;
		case MSG_ORTHO_VERT:
			doc->SetOrthoMode( Document::OrthoVert );
			break;
		case MSG_ORTHO_HORIZ:
			doc->SetOrthoMode( Document::OrthoHoriz );
			break;
	}	
}

void DialogGuide :: Init( Document* doc )
{
	m_SnapActive->SetValue( doc->GetSnapActive() );
	m_GridActive->SetValue( doc->GetGridActive() );
	m_OrthoNone->SetValue( doc->GetOrthoMode() == Document::OrthoNone );
	m_OrthoVert->SetValue( doc->GetOrthoMode() == Document::OrthoVert );
	m_OrthoHoriz->SetValue( doc->GetOrthoMode() == Document::OrthoHoriz );
	m_OrthoBoth->SetValue( doc->GetOrthoMode() == Document::OrthoBoth );
}

/////////////////////////////////////////////////////////////////////////////////////////////////////
//
// P R I V A T E   M E T H O D S
//
/////////////////////////////////////////////////////////////////////////////////////////////////////

void DialogGuide :: _Layout()
{
	Rect cFrame = ConvertFromParent( GetFrame() );
	m_Table->SetFrame( cFrame );	
}

