// oCADis (C)opyright 2006 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include <util/message.h>
#include "colour_button.h"


using namespace os;

ColourButton :: ColourButton( const Rect& cFrame, Message* msg, uint32 nResizeMask, uint32 nFlags ) 
							    : Button( cFrame, "", "", new Message( MSG_COLOUR ), nResizeMask, nFlags )
{
	m_Invoker = new Invoker( msg );

	m_Selector = new ColorRequester( "Colour", 0 );

	// Set start colour
	m_theColour.red = 0;
	m_theColour.green = 0;
	m_theColour.blue = 0;
}

ColourButton :: ~ColourButton()
{
	delete m_Invoker;
	delete m_Selector;
}

void ColourButton :: Paint( const Rect& cUpdate )
{
	Rect cFillRect = GetBounds();
	DrawFrame( cFillRect, FRAME_RAISED );
	cFillRect.Resize( 2, 2, -2, -2 );
	FillRect( cFillRect, m_theColour );
}

Point ColourButton :: GetPreferredSize( bool bLargest ) const
{
	return Point( 18, 18 );
}

void ColourButton :: HandleMessage( Message* pcMessage )
{
	switch( pcMessage->GetCode() )
	{
		case MSG_COLOUR:
		{
			if( !m_Selector->IsVisible() )
			{			
				Invoker* pcInv = new Invoker( new Message( MSG_SELECTOR ) );
				pcInv->SetTarget( this );
				m_Selector->SetColor( m_theColour );
				m_Selector->SetTitle( "Select colour" );
				m_Selector->Go( pcInv );
			}
			else
			{
				m_Selector->Hide();
				m_Selector->Show();
				m_Selector->MakeFocus();	
			}
			break;
		}
		case MSG_SELECTOR:	
		{
			Color32 cCol;
			pcMessage->FindColor32( "color", &cCol );
			m_theColour = cCol;
			Invalidate();
			Flush();
			m_Invoker->Invoke();
			break;
		}
	}
}

void ColourButton :: AllAttached( void )
{
	Button::SetTarget( this );
}

void ColourButton :: SetColour( Color32_s colour ) 
{ 
	m_theColour = colour; 
	Invalidate();
	Flush();
}

void ColourButton :: SetTarget( Handler* pcHandler )
{
	m_Invoker->SetTarget( pcHandler );
}

