// oCADis (C)opyright 2006 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef __CANVASBITMAP_H_
#define __CANVASBITMAP_H_


#include <gui/bitmap.h>
#include <gui/point.h>

#include <vector>
#include <agg_rasterizer_outline.h>
#include <agg_rasterizer_outline_aa.h>
#include <agg_rasterizer_scanline_aa.h>
#include <agg_renderer_outline_aa.h>
#include <agg_renderer_primitives.h>
#include <agg_renderer_scanline.h>
#include <agg_scanline_bin.h>
#include <agg_scanline_p.h>
#include <agg_scanline_u.h>
#include <agg_rendering_buffer.h>
#include <agg_pixfmt_rgba.h>
#include <agg_math_stroke.h>


class CanvasBitmap : public os::Bitmap
{
public:
	CanvasBitmap( int width, int height );
	~CanvasBitmap();

	void SetWidth( double width );
	double GetWidth();

	void SetColour( double r, double g, double b );
	void GetColour( double& r, double& g, double& b);

	void SetPattern( double* dashes, int num_dashes, double offset = 0.0f );
	void SetAntiAlias( bool use = true );

	void DrawLine( os::Point p1, os::Point p2 );
	void DrawArc( os::Point center, double radius, double start_angle, double end_angle );
	void DrawCircle( os::Point center, double radius );
	void DrawRectangle( os::Point offset, os::Point size );
	void DrawBitmap( CanvasBitmap* src, os::Rect size );
	void DrawPixel( os::Point p, double r, double g, double b, double alpha = 1.0f );

	void Fill();

private:
	template<class VertexSource>
	void _StrokePath( VertexSource& path );

	typedef agg::renderer_base<agg::pixfmt_rgba32> 				renderer_base;
	typedef agg::renderer_primitives<renderer_base>         	outline_renderer_type;
	typedef agg::rasterizer_outline<outline_renderer_type>  	outline_rasterizer_type;
	typedef agg::scanline_bin									scanline_unpacked_type;
	typedef agg::scanline_bin									scanline_packed_type;
	typedef agg::renderer_scanline_aa_solid<renderer_base>		renderer_type;
	typedef agg::renderer_scanline_bin_solid<renderer_base> 	renderer_bin_type;
	typedef agg::rasterizer_scanline_aa<>						rasterizer_type;
	typedef agg::scanline_p8									scanline_type;
	
	agg::rendering_buffer* 		m_RenderBuffer;
	renderer_base* 				m_RendererBase;
	agg::pixfmt_rgba32* 		m_PixelFormat;
	outline_renderer_type* 		m_OutlineRenderer;
	outline_rasterizer_type* 	m_OutlineRasterizer;

	scanline_type*				m_Scanline;

	scanline_unpacked_type*		m_UnpackedScanline;
	scanline_packed_type*		m_PackedScanline;
	rasterizer_type*			m_Rasterizer;
	renderer_type*				m_Renderer;
	renderer_bin_type*			m_RendererBin;

	double m_Width;
	agg::pixfmt_rgba32::color_type m_Colour;

	std::vector<double> m_Pattern;
	double m_Offset;
};

#endif
