// EFileBrowser (C)opyright 2007 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef __TAB_BROWSER_H__
#define __TAB_BROWSER_H__

#include "fileview/fileview.h"



class BrowserTab : public FileView
{
public:
	struct DirectoryStat
	{
		int no_folders;
		int no_files;

		int no_sel_folders;
		int no_sel_files;

		int total_sel_size;
		int total_size;
	};

	BrowserTab( os::String path, os::Message* dir_chg, os::Message* ready, os::Message* sel_chg, os::Message* tab_open );
	~BrowserTab();

	os::String GetName();

	void SetPath( os::String new_path, bool save_path = true );

	void Up();
	void Back();

	void GetStat( struct DirectoryStat* stat );

private:
	class _Private;
	_Private* m;
};

#endif
