// EFileBrowser (C)opyright 2007 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include <gui/layoutview.h>
#include "sidebar_foldertreeview.h"
#include "foldertreeview/foldertreeview.h"
#include "messages.h"
#include "common.h"

using namespace os;

///////////////////////////////////////////////////////////////////////////////
//
// P R I V A T E
//
///////////////////////////////////////////////////////////////////////////////

class SideBarFolderTreeView :: _Private
{
public:
	_Private() {};

	FolderTreeView* m_Tree;
};

///////////////////////////////////////////////////////////////////////////////
//
// T H E   C L A S S
//
///////////////////////////////////////////////////////////////////////////////
SideBarFolderTreeView :: SideBarFolderTreeView( Message* hide_msg, Message* msg ) : SideBar( "Folders", hide_msg )
{
	// Create the private class
	m = new _Private();

	m->m_Tree = new FolderTreeView( Rect(), "/" );
	m->m_Tree->SetDirChangeMsg( msg );
	SideBar::GetRoot()->AddChild( m->m_Tree, 1.0f );
}

SideBarFolderTreeView :: ~SideBarFolderTreeView()
{
	delete m;
}

void SideBarFolderTreeView :: SetPath( String path )
{
	m->m_Tree->SetPath( path );
}


